/*
 * Decompiled with CFR 0.152.
 */
package io.searchbox.core.search.aggregation;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.searchbox.core.search.aggregation.AggregationField;
import io.searchbox.core.search.aggregation.Bucket;
import io.searchbox.core.search.aggregation.BucketAggregation;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public class HistogramAggregation
extends BucketAggregation {
    public static final String TYPE = "histogram";
    private List<Histogram> histograms = new LinkedList<Histogram>();

    public HistogramAggregation(String name, JsonObject histogramAggregation) {
        super(name, histogramAggregation);
        if (histogramAggregation.has(String.valueOf((Object)AggregationField.BUCKETS)) && histogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).isJsonArray()) {
            this.parseBuckets(histogramAggregation.get(String.valueOf((Object)AggregationField.BUCKETS)).getAsJsonArray());
        }
    }

    private void parseBuckets(JsonArray bucketsSource) {
        for (JsonElement bucketv : bucketsSource) {
            JsonObject bucket = bucketv.getAsJsonObject();
            Histogram histogram = new Histogram(bucket, bucket.get(String.valueOf((Object)AggregationField.KEY)).getAsLong(), (Long)bucket.get(String.valueOf((Object)AggregationField.DOC_COUNT)).getAsLong());
            this.histograms.add(histogram);
        }
    }

    public List<Histogram> getBuckets() {
        return this.histograms;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        HistogramAggregation rhs = (HistogramAggregation)obj;
        return new EqualsBuilder().appendSuper(super.equals(obj)).append(this.histograms, rhs.histograms).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder().appendSuper(super.hashCode()).append(this.histograms).toHashCode();
    }

    public static class Histogram
    extends Bucket {
        private Long key;

        Histogram(JsonObject bucket, Long key, Long count) {
            super(bucket, count);
            this.key = key;
        }

        public Long getKey() {
            return this.key;
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            Histogram rhs = (Histogram)obj;
            return new EqualsBuilder().appendSuper(super.equals(obj)).append((Object)this.key, (Object)rhs.key).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder().appendSuper(super.hashCode()).append((Object)this.key).toHashCode();
        }
    }
}

