/*
 * Decompiled with CFR 0.152.
 */
package mutiny.zero.internal;

import java.util.Queue;
import java.util.concurrent.Flow;
import mutiny.zero.internal.Helper;
import mutiny.zero.internal.TubeBase;

public abstract class BufferingTubeBase<T>
extends TubeBase<T> {
    protected boolean delayedComplete = false;

    public BufferingTubeBase(Flow.Subscriber<? super T> subscriber) {
        super(subscriber);
    }

    abstract Queue<T> overflowQueue();

    @Override
    public void request(long n) {
        if (this.cancelled) {
            return;
        }
        if (n <= 0L) {
            this.fail(Helper.negativeRequest(n));
        } else {
            T bufferedItem;
            if (this.overflowQueue().isEmpty()) {
                super.request(n);
                return;
            }
            long remaining = n;
            do {
                if ((bufferedItem = this.overflowQueue().poll()) == null) continue;
                this.dispatchQueue.offer(bufferedItem);
                --remaining;
            } while (bufferedItem != null && remaining > 0L);
            Helper.add(this.requested, n);
            this.requestConsumer.accept(n);
            this.completed = this.delayedComplete && this.overflowQueue().isEmpty();
        }
        this.drainLoop();
    }

    @Override
    public void complete() {
        if (this.overflowQueue().isEmpty()) {
            super.complete();
        } else {
            this.delayedComplete = true;
        }
    }
}

