/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.connector;

import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import io.smallrye.reactive.messaging.connector.ClassWriter;
import io.smallrye.reactive.messaging.connector.CommonConfigurationClassWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.tools.JavaFileObject;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;

public class ConfigurationClassWriter {
    private final ProcessingEnvironment environment;

    public ConfigurationClassWriter(ProcessingEnvironment environment) {
        this.environment = environment;
    }

    public void generateAllClasses(Connector connector, String className, List<ConnectorAttribute> common, List<ConnectorAttribute> incoming, List<ConnectorAttribute> outgoing) throws IOException {
        CommonConfigurationClassWriter.generate(this.environment, connector, className, common);
        String packageName = ClassWriter.getPackage(className);
        String incomingConfigClassName = ClassWriter.getConfigClassName(className, "IncomingConfiguration");
        String outgoingConfigClassName = ClassWriter.getConfigClassName(className, "OutgoingConfiguration");
        String parentClassName = ClassWriter.getConfigClassName(className, "CommonConfiguration");
        String incomingConfigSimpleClassName = ClassWriter.getSimpleClassName(incomingConfigClassName);
        String outgoingConfigSimpleClassName = ClassWriter.getSimpleClassName(outgoingConfigClassName);
        String parentConfigSimpleClassName = ClassWriter.getSimpleClassName(parentClassName);
        ClassWriter.log("Generating incoming configuration for connector `%s`: %s", connector.value(), incomingConfigClassName);
        this.generate(incoming, packageName, incomingConfigClassName, incomingConfigSimpleClassName, parentConfigSimpleClassName, "incoming", connector.value());
        ClassWriter.log("Generating outgoing configuration for connector `%s`: %s", connector.value(), outgoingConfigClassName);
        this.generate(outgoing, packageName, outgoingConfigClassName, outgoingConfigSimpleClassName, parentConfigSimpleClassName, "outgoing", connector.value());
    }

    private void generate(List<ConnectorAttribute> attributes, String packageName, String configClassName, String configSimpleClassName, String parentConfigSimpleClassName, String direction, String connector) throws IOException {
        JavaFileObject file = this.environment.getFiler().createSourceFile(configClassName, new Element[0]);
        file.delete();
        try (PrintWriter out = new PrintWriter(file.openWriter());){
            ClassWriter.writePackageDeclaration(packageName, out);
            ClassWriter.writeImportStatements(out);
            this.writeClassDeclaration(configSimpleClassName, direction, connector, out, parentConfigSimpleClassName);
            this.writeConstructor(configSimpleClassName, out);
            attributes.forEach(ca -> ClassWriter.generateGetterForAttribute(ca, connector, out));
            ConfigurationClassWriter.writeValidateMethod(attributes, out);
            out.println("}");
        }
    }

    private void writeConstructor(String configSimpleClassName, PrintWriter out) {
        out.println();
        out.println("  /**");
        out.println("   * Creates a new " + configSimpleClassName + ".");
        out.println("   */");
        out.println("  public " + configSimpleClassName + "(Config config) {");
        out.println("    super(config);");
        out.println("    validate();");
        out.println("  }");
        out.println();
    }

    private void writeClassDeclaration(String configSimpleClassName, String direction, String connector, PrintWriter out, String parentClass) {
        out.println();
        out.println("/**");
        out.println(" * Extract the " + direction + " configuration for the {@code " + connector + "} connector.");
        out.println("*/");
        out.print(String.format("public class %s extends %s {", configSimpleClassName, parentClass));
        out.println();
    }

    private static void writeValidateMethod(List<ConnectorAttribute> attributes, PrintWriter out) {
        out.println("  public void validate() {");
        out.println("    super.validate();");
        attributes.forEach(ca -> {
            if (ca.mandatory()) {
                out.println(String.format("    %s();", ClassWriter.getMethodName(ca)));
            }
        });
        out.println("  }");
    }
}

