/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.connector;

import com.google.auto.service.AutoService;
import io.smallrye.reactive.messaging.annotations.ConnectorAttribute;
import io.smallrye.reactive.messaging.annotations.ConnectorAttributes;
import io.smallrye.reactive.messaging.connector.ClassWriter;
import io.smallrye.reactive.messaging.connector.ConfigurationClassWriter;
import io.smallrye.reactive.messaging.connector.ConfigurationDocWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.eclipse.microprofile.reactive.messaging.spi.Connector;

@SupportedAnnotationTypes(value={"io.smallrye.reactive.messaging.annotations.ConnectorAttributes", "io.smallrye.reactive.messaging.annotations.ConnectorAttribute"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@AutoService(value={Processor.class})
public class ConnectorAttributeProcessor
extends AbstractProcessor {
    private volatile boolean invoked;

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.invoked) {
            return true;
        }
        this.invoked = true;
        Set<? extends Element> annotated = roundEnv.getElementsAnnotatedWith(ConnectorAttributes.class);
        Set<? extends Element> others = roundEnv.getElementsAnnotatedWith(ConnectorAttribute.class);
        LinkedHashSet<Element> all = new LinkedHashSet<Element>();
        all.addAll(annotated);
        all.addAll(others);
        for (Element annotatedElement : all) {
            String className = annotatedElement.toString();
            Connector connector = this.getConnector(annotatedElement);
            ConnectorAttributes annotation = annotatedElement.getAnnotation(ConnectorAttributes.class);
            ConnectorAttribute[] attributes = annotation == null ? new ConnectorAttribute[]{annotatedElement.getAnnotation(ConnectorAttribute.class)} : annotation.value();
            ArrayList<ConnectorAttribute> incomingAttributes = new ArrayList<ConnectorAttribute>();
            ArrayList<ConnectorAttribute> outgoingAttributes = new ArrayList<ConnectorAttribute>();
            ArrayList<ConnectorAttribute> commonAttributes = new ArrayList<ConnectorAttribute>();
            for (ConnectorAttribute attribute : attributes) {
                this.addAttributeToList(commonAttributes, attribute, ConnectorAttribute.Direction.INCOMING_AND_OUTGOING);
                this.addAttributeToList(incomingAttributes, attribute, ConnectorAttribute.Direction.INCOMING);
                this.addAttributeToList(outgoingAttributes, attribute, ConnectorAttribute.Direction.OUTGOING);
            }
            this.validate(commonAttributes);
            this.validate(incomingAttributes);
            this.validate(outgoingAttributes);
            ConfigurationClassWriter classWriter = new ConfigurationClassWriter(this.processingEnv);
            ConfigurationDocWriter docWriter = new ConfigurationDocWriter(this.processingEnv);
            try {
                classWriter.generateAllClasses(connector, className, commonAttributes, incomingAttributes, outgoingAttributes);
                docWriter.generate(connector, commonAttributes, incomingAttributes, outgoingAttributes);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return true;
    }

    private void validate(List<ConnectorAttribute> attributes) {
        attributes.forEach(ca -> {
            if (ca.mandatory() && ClassWriter.hasDefaultValue(ca)) {
                throw new IllegalArgumentException("The attribute " + ca.name() + " cannot be mandatory and have a default value");
            }
        });
    }

    private void addAttributeToList(List<ConnectorAttribute> list, ConnectorAttribute attribute, ConnectorAttribute.Direction direction) {
        if (attribute.direction() == direction) {
            list.add(attribute);
        }
    }

    private Connector getConnector(Element annotatedElement) {
        Connector connector = annotatedElement.getAnnotation(Connector.class);
        if (connector == null) {
            throw new IllegalStateException("Expecting the usage of `@ConnectorAttribute` on a class annotated with @Connector");
        }
        return connector;
    }
}

