/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.ProcessingException;
import io.smallrye.reactive.messaging.annotations.Acknowledgment;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public abstract class AbstractMediator {
    protected final MediatorConfiguration configuration;
    private Invoker invoker;

    public AbstractMediator(MediatorConfiguration configuration) {
        this.configuration = configuration;
    }

    public synchronized void setInvoker(Invoker invoker) {
        this.invoker = invoker;
    }

    public void run() {
    }

    public void connectToUpstream(Publisher<? extends Message> publisher) {
    }

    public MediatorConfiguration configuration() {
        return this.configuration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize(Object bean) {
        AbstractMediator abstractMediator = this;
        synchronized (abstractMediator) {
            if (this.invoker == null) {
                this.invoker = args -> {
                    try {
                        return this.configuration.getMethod().invoke(bean, args);
                    }
                    catch (Exception e) {
                        throw new ProcessingException(this.configuration.methodAsString(), e);
                    }
                };
            }
        }
    }

    protected <T> T invoke(Object ... args) {
        Objects.requireNonNull(this.invoker, "Invoker not initialized");
        return (T)this.invoker.invoke(args);
    }

    protected CompletionStage<? extends Void> getAckOrCompletion(Message<?> message) {
        CompletionStage<Void> ack = message.ack();
        if (ack != null) {
            return ack;
        }
        return CompletableFuture.completedFuture(null);
    }

    public Publisher<Message> getComputedPublisher() {
        return null;
    }

    public MediatorConfiguration getConfiguration() {
        return this.configuration;
    }

    public String getMethodAsString() {
        return this.configuration.methodAsString();
    }

    public Subscriber<Message> getComputedSubscriber() {
        return null;
    }

    public abstract boolean isConnected();

    protected Function<Message, ? extends CompletionStage<? extends Message>> managePostProcessingAck() {
        return message -> {
            if (this.configuration.getAcknowledgment() == Acknowledgment.Mode.POST_PROCESSING) {
                return this.getAckOrCompletion((Message<?>)message).thenApply(x -> message);
            }
            return CompletableFuture.completedFuture(message);
        };
    }

    protected Function<Message, ? extends CompletionStage<? extends Message>> managePreProcessingAck() {
        return message -> {
            if (this.configuration.getAcknowledgment() == Acknowledgment.Mode.PRE_PROCESSING) {
                return this.getAckOrCompletion((Message<?>)message).thenApply(x -> message);
            }
            return CompletableFuture.completedFuture(message);
        };
    }

    public Publisher<Message> decorate(Publisher<Message> input) {
        if (input == null) {
            return null;
        }
        if (this.configuration.getBroadcast()) {
            if (this.configuration.getNumberOfSubscriberBeforeConnecting() != 0) {
                return Flowable.fromPublisher(input).publish().autoConnect(this.configuration.getNumberOfSubscriberBeforeConnecting());
            }
            return Flowable.fromPublisher(input).publish().autoConnect();
        }
        return input;
    }
}

