/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import java.util.Objects;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

public class PublisherMediator
extends AbstractMediator {
    private Publisher publisher;

    public PublisherMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.shape() != Shape.PUBLISHER) {
            throw new IllegalArgumentException("Expected a Publisher shape, received a " + (Object)((Object)configuration.shape()));
        }
    }

    @Override
    public Publisher<Message> getComputedPublisher() {
        return Objects.requireNonNull(this.publisher);
    }

    @Override
    public boolean isConnected() {
        return true;
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.production()) {
            case STREAM_OF_MESSAGE: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfMessages();
                    break;
                }
                this.produceAPublisherOfMessages();
                break;
            }
            case STREAM_OF_PAYLOAD: {
                if (this.configuration.usesBuilderTypes()) {
                    this.produceAPublisherBuilderOfPayloads();
                    break;
                }
                this.produceAPublisherOfPayloads();
                break;
            }
            case INDIVIDUAL_PAYLOAD: {
                this.produceIndividualPayloads();
                break;
            }
            case INDIVIDUAL_MESSAGE: {
                this.produceIndividualMessages();
                break;
            }
            case COMPLETION_STAGE_OF_MESSAGE: {
                this.produceIndividualCompletionStageOfMessages();
                break;
            }
            case COMPLETION_STAGE_OF_PAYLOAD: {
                this.produceIndividualCompletionStageOfPayloads();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected production type: " + (Object)((Object)this.configuration.production()));
            }
        }
        assert (this.publisher != null);
    }

    private void produceAPublisherBuilderOfMessages() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.setPublisher(builder.buildRs());
    }

    private void setPublisher(Publisher publisher) {
        this.publisher = this.decorate((Publisher<Message>)publisher);
    }

    private <P> void produceAPublisherBuilderOfPayloads() {
        PublisherBuilder builder = (PublisherBuilder)this.invoke(new Object[0]);
        this.setPublisher(builder.map(Message::of).buildRs());
    }

    private void produceAPublisherOfMessages() {
        this.setPublisher((Publisher)this.invoke(new Object[0]));
    }

    private <P> void produceAPublisherOfPayloads() {
        Publisher pub = (Publisher)this.invoke(new Object[0]);
        this.setPublisher(ReactiveStreams.fromPublisher((Publisher)pub).map(Message::of).buildRs());
    }

    private void produceIndividualMessages() {
        this.setPublisher(ReactiveStreams.generate(() -> {
            Message message = (Message)this.invoke(new Object[0]);
            Objects.requireNonNull(message, "The method " + this.configuration.methodAsString() + " returned an invalid value: null");
            return message;
        }).buildRs());
    }

    private <T> void produceIndividualPayloads() {
        this.setPublisher(ReactiveStreams.generate(() -> this.invoke(new Object[0])).map(Message::of).buildRs());
    }

    private void produceIndividualCompletionStageOfMessages() {
        this.setPublisher(ReactiveStreams.generate(() -> (CompletionStage)this.invoke(new Object[0])).flatMapCompletionStage(Function.identity()).buildRs());
    }

    private <P> void produceIndividualCompletionStageOfPayloads() {
        this.setPublisher(ReactiveStreams.generate(() -> (CompletionStage)this.invoke(new Object[0])).flatMapCompletionStage(Function.identity()).map(Message::of).buildRs());
    }
}

