/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.StreamRegistry;
import io.smallrye.reactive.messaging.annotations.Stream;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import io.smallrye.reactive.messaging.extension.StreamProducer;
import io.smallrye.reactive.messaging.impl.VertxBeanRegistration;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessManagedBean;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveMessagingExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingExtension.class);
    private List<MediatorBean<?>> mediatorBeans = new ArrayList();
    private List<InjectionPoint> streamInjectionPoints = new ArrayList<InjectionPoint>();

    <T> void processClassesContainingMediators(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        if (annotatedType.getMethods().stream().anyMatch(m -> m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class))) {
            this.mediatorBeans.add(new MediatorBean(event.getBean(), event.getAnnotatedBeanClass()));
        }
    }

    <T extends Publisher<?>> void processStreamPublisherInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Stream stream = StreamProducer.getStreamQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends PublisherBuilder<?>> void processStreamPublisherBuilderInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Stream stream = StreamProducer.getStreamQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    void afterBeanDiscovery(@Observes AfterBeanDiscovery discovery, BeanManager beanManager) {
        VertxBeanRegistration.registerVertxBeanIfNeeded(discovery, beanManager);
    }

    void afterDeploymentValidation(@Observes AfterDeploymentValidation done, BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        StreamRegistry registry = (StreamRegistry)instance.select(StreamRegistry.class, new Annotation[0]).get();
        MediatorManager mediatorManager = (MediatorManager)instance.select(MediatorManager.class, new Annotation[0]).get();
        for (MediatorBean<?> mediatorBean : this.mediatorBeans) {
            LOGGER.info("Analyzing mediator bean:" + mediatorBean.bean);
            mediatorManager.analyze(mediatorBean.annotatedType, mediatorBean.bean);
        }
        this.mediatorBeans.clear();
        CompletableFuture<Void> future = mediatorManager.initializeAndRun();
        try {
            future.get();
            Set<String> names = registry.getPublisherNames();
            for (InjectionPoint ip : this.streamInjectionPoints) {
                String name = StreamProducer.getStreamName(ip);
                if (names.contains(name)) continue;
                done.addDeploymentProblem((Throwable)new DeploymentException("No stream found for name: " + name + ", injection point: " + ip));
            }
            this.streamInjectionPoints.clear();
        }
        catch (ExecutionException e) {
            done.addDeploymentProblem(e.getCause());
        }
        catch (InterruptedException e) {
            done.addDeploymentProblem((Throwable)e);
        }
    }

    static class MediatorBean<T> {
        final Bean<T> bean;
        final AnnotatedType<T> annotatedType;

        MediatorBean(Bean<T> bean, AnnotatedType<T> annotatedType) {
            this.bean = bean;
            this.annotatedType = annotatedType;
        }
    }
}

