/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.reactivex.Flowable;
import io.smallrye.reactive.messaging.StreamRegistry;
import io.smallrye.reactive.messaging.annotations.Stream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.inject.Inject;
import org.apache.commons.lang3.reflect.TypeUtils;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Publisher;

@ApplicationScoped
public class StreamProducer {
    @Inject
    StreamRegistry streamRegistry;

    @Produces
    @Stream(value="")
    <T> Flowable<T> producePublisher(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable((Type)first, Message.class)) {
            return (Flowable)StreamProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (Flowable)StreamProducer.cast(Flowable.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    @Produces
    @Stream(value="")
    <T> PublisherBuilder<T> producePublisherBuilder(InjectionPoint injectionPoint) {
        Type first = this.getFirstParameter(injectionPoint.getType());
        if (TypeUtils.isAssignable((Type)first, Message.class)) {
            return (PublisherBuilder)StreamProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)));
        }
        return (PublisherBuilder)StreamProducer.cast(ReactiveStreams.fromPublisher(this.getPublisher(injectionPoint)).map(Message::getPayload));
    }

    private Publisher<? extends Message> getPublisher(InjectionPoint injectionPoint) {
        String name = StreamProducer.getStreamName(injectionPoint);
        List<Publisher<? extends Message>> list = this.streamRegistry.getPublishers(name);
        if (list.isEmpty()) {
            throw new IllegalStateException("Unable to find a stream with the name " + name + ", available streams are: " + this.streamRegistry.getPublisherNames());
        }
        return list.get(0);
    }

    private Type getFirstParameter(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments()[0];
        }
        return null;
    }

    static String getStreamName(InjectionPoint injectionPoint) {
        Stream qualifier = StreamProducer.getStreamQualifier(injectionPoint);
        if (qualifier == null) {
            throw new IllegalStateException("@Stream qualifier not found on + " + injectionPoint);
        }
        return qualifier.value();
    }

    static Stream getStreamQualifier(InjectionPoint injectionPoint) {
        for (Annotation qualifier : injectionPoint.getQualifiers()) {
            if (!qualifier.annotationType().equals(Stream.class)) continue;
            return (Stream)qualifier;
        }
        return null;
    }

    private static <T> T cast(Object obj) {
        return (T)obj;
    }
}

