/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.vertx.reactivex.core.Vertx;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Optional;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxBeanRegistration {
    private static final Logger LOGGER = LoggerFactory.getLogger(VertxBeanRegistration.class);

    private VertxBeanRegistration() {
    }

    public static void registerVertxBeanIfNeeded(AfterBeanDiscovery discovery, BeanManager beanManager) {
        Optional optional = beanManager.getBeans(Vertx.class, new Annotation[0]).stream().findFirst();
        if (!optional.isPresent()) {
            LOGGER.debug("Declaring a Vert.x bean");
            discovery.addBean().types(new Type[]{Vertx.class}).beanClass(Vertx.class).scope(Singleton.class).produceWith(i -> Vertx.vertx()).disposeWith((vertx, i) -> vertx.close());
        }
    }
}

