/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.reactive.messaging.Invoker;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.MediatorConfigurationSupport;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.annotations.Broadcast;
import io.smallrye.reactive.messaging.annotations.Incomings;
import io.smallrye.reactive.messaging.annotations.Merge;
import io.smallrye.reactive.messaging.helpers.TypeUtils;
import io.smallrye.reactive.messaging.helpers.Validation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.enterprise.inject.spi.Bean;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.Outgoing;

public class DefaultMediatorConfiguration
implements MediatorConfiguration {
    private final Bean<?> mediatorBean;
    private final Method method;
    private Class<?> returnType;
    private Class<?>[] parameterTypes;
    private Shape shape;
    private List<String> incomingValues = Collections.emptyList();
    private String outgoingValue = null;
    private Acknowledgment.Strategy acknowledgment;
    private Integer broadcastValue = null;
    private MediatorConfiguration.Production production = MediatorConfiguration.Production.NONE;
    private MediatorConfiguration.Consumption consumption = MediatorConfiguration.Consumption.NONE;
    private boolean useBuilderTypes = false;
    private Merge.Mode mergePolicy;
    private boolean isBlocking = false;
    private String workerPoolName = null;
    private boolean isOrderedExecution;
    private MediatorConfigurationSupport mediatorConfigurationSupport;

    public DefaultMediatorConfiguration(Method method, Bean<?> bean) {
        this.method = Objects.requireNonNull(method, "'method' must be set");
        this.returnType = method.getReturnType();
        this.parameterTypes = method.getParameterTypes();
        this.mediatorBean = Objects.requireNonNull(bean, "'bean' must be set");
        this.mediatorConfigurationSupport = new MediatorConfigurationSupport(this.methodAsString(), this.returnType, this.parameterTypes, new ReturnTypeGenericTypeAssignable(method), this.parameterTypes.length == 0 ? new AlwaysInvalidIndexGenericTypeAssignable() : new MethodParamGenericTypeAssignable(method, 0));
    }

    public void compute(Incomings incomings, Outgoing outgoing, Blocking blocking) {
        Incoming[] values = incomings.value();
        if (values.length == 0) {
            throw this.getIncomingError("@Incomings must contain a non-empty array of @Incoming");
        }
        this.compute(Arrays.asList(values), outgoing, blocking);
    }

    public void compute(List<Incoming> incomings, Outgoing outgoing, Blocking blocking) {
        if (incomings != null) {
            for (Incoming incoming : incomings) {
                if (!Validation.isBlank(incoming.value())) continue;
                throw this.getIncomingError("value is blank or null");
            }
        } else {
            incomings = Collections.emptyList();
        }
        if (outgoing != null && Validation.isBlank(outgoing.value())) {
            throw this.getOutgoingError("value is blank or null");
        }
        this.shape = this.mediatorConfigurationSupport.determineShape(incomings, outgoing);
        this.acknowledgment = this.mediatorConfigurationSupport.processSuppliedAcknowledgement(incomings, () -> {
            Acknowledgment annotation = this.method.getAnnotation(Acknowledgment.class);
            return annotation != null ? annotation.value() : null;
        });
        if (!incomings.isEmpty()) {
            this.incomingValues = incomings.stream().map(Incoming::value).collect(Collectors.toList());
        }
        if (outgoing != null) {
            this.outgoingValue = outgoing.value();
        }
        if (blocking != null) {
            this.isBlocking = true;
            this.isOrderedExecution = blocking.ordered();
            if (!blocking.value().equals("<no-value>")) {
                this.workerPoolName = blocking.value();
            }
        }
        MediatorConfigurationSupport.ValidationOutput validationOutput = this.mediatorConfigurationSupport.validate(this.shape, this.acknowledgment);
        this.production = validationOutput.getProduction();
        this.consumption = validationOutput.getConsumption();
        if (validationOutput.getUseBuilderTypes() != null) {
            this.useBuilderTypes = validationOutput.getUseBuilderTypes();
        }
        if (this.acknowledgment == null) {
            this.acknowledgment = this.mediatorConfigurationSupport.processDefaultAcknowledgement(this.shape, this.consumption);
        }
        this.mergePolicy = this.mediatorConfigurationSupport.processMerge(incomings, () -> {
            Merge annotation = this.method.getAnnotation(Merge.class);
            return annotation != null ? annotation.value() : null;
        });
        this.broadcastValue = this.mediatorConfigurationSupport.processBroadcast(outgoing, () -> {
            Broadcast annotation = this.method.getAnnotation(Broadcast.class);
            return annotation != null ? Integer.valueOf(annotation.value()) : null;
        });
        if (this.isBlocking) {
            this.mediatorConfigurationSupport.validateBlocking(validationOutput);
        }
    }

    public Shape shape() {
        return this.shape;
    }

    private IllegalArgumentException getOutgoingError(String message) {
        return new IllegalArgumentException("Invalid method annotated with @Outgoing: " + this.methodAsString() + " - " + message);
    }

    private IllegalArgumentException getIncomingError(String message) {
        return new IllegalArgumentException("Invalid method annotated with @Incoming: " + this.methodAsString() + " - " + message);
    }

    public String getOutgoing() {
        return this.outgoingValue;
    }

    public List<String> getIncoming() {
        return this.incomingValues;
    }

    public String methodAsString() {
        return this.mediatorBean.getBeanClass().getName() + "#" + this.method.getName();
    }

    public Method getMethod() {
        return this.method;
    }

    public Class<?> getReturnType() {
        return this.returnType;
    }

    public Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public MediatorConfiguration.Consumption consumption() {
        return this.consumption;
    }

    public MediatorConfiguration.Production production() {
        return this.production;
    }

    public boolean usesBuilderTypes() {
        return this.useBuilderTypes;
    }

    public Acknowledgment.Strategy getAcknowledgment() {
        return this.acknowledgment;
    }

    public Merge.Mode getMerge() {
        return this.mergePolicy;
    }

    public boolean getBroadcast() {
        return this.broadcastValue != null;
    }

    public Bean<?> getBean() {
        return this.mediatorBean;
    }

    public int getNumberOfSubscriberBeforeConnecting() {
        if (!this.getBroadcast()) {
            return -1;
        }
        return this.broadcastValue;
    }

    public boolean isBlocking() {
        return this.isBlocking;
    }

    public String getWorkerPoolName() {
        return this.workerPoolName;
    }

    public boolean isBlockingExecutionOrdered() {
        return this.isOrderedExecution;
    }

    public Class<? extends Invoker> getInvokerClass() {
        return null;
    }

    private static class MethodParamGenericTypeAssignable
    extends ReflectionGenericTypeAssignable {
        MethodParamGenericTypeAssignable(Method method, int paramIndex) {
            super(MethodParamGenericTypeAssignable.getGenericParameterType(method, paramIndex));
        }

        private static Type getGenericParameterType(Method method, int paramIndex) {
            Type[] genericParameterTypes = method.getGenericParameterTypes();
            if (genericParameterTypes.length < paramIndex + 1) {
                throw new IllegalArgumentException("Method " + method + " only has " + genericParameterTypes.length + " so parameter with index " + paramIndex + " cannot be retrieved");
            }
            return genericParameterTypes[paramIndex];
        }
    }

    private static class AlwaysInvalidIndexGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        private AlwaysInvalidIndexGenericTypeAssignable() {
        }

        @Override
        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }
    }

    private static class ReturnTypeGenericTypeAssignable
    extends ReflectionGenericTypeAssignable {
        ReturnTypeGenericTypeAssignable(Method method) {
            super(method.getGenericReturnType());
        }
    }

    static class ReflectionGenericTypeAssignable
    implements MediatorConfigurationSupport.GenericTypeAssignable {
        private final Type type;

        public ReflectionGenericTypeAssignable(Type type) {
            this.type = type;
        }

        @Override
        public MediatorConfigurationSupport.GenericTypeAssignable.Result check(Class<?> target, int index) {
            if (!(this.type instanceof ParameterizedType)) {
                return MediatorConfigurationSupport.GenericTypeAssignable.Result.NotGeneric;
            }
            Type[] arguments = ((ParameterizedType)this.type).getActualTypeArguments();
            if (arguments.length >= index + 1) {
                return TypeUtils.isAssignable(arguments[index], target) ? MediatorConfigurationSupport.GenericTypeAssignable.Result.Assignable : MediatorConfigurationSupport.GenericTypeAssignable.Result.NotAssignable;
            }
            return MediatorConfigurationSupport.GenericTypeAssignable.Result.InvalidIndex;
        }
    }
}

