/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging;

import io.smallrye.mutiny.Uni;
import io.smallrye.reactive.messaging.AbstractMediator;
import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.helpers.ClassUtils;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.Function;
import org.eclipse.microprofile.reactive.messaging.Acknowledgment;
import org.eclipse.microprofile.reactive.messaging.Message;
import org.eclipse.microprofile.reactive.messaging.Metadata;
import org.eclipse.microprofile.reactive.streams.operators.ProcessorBuilder;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.eclipse.microprofile.reactive.streams.operators.ReactiveStreams;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;

public class ProcessorMediator
extends AbstractMediator {
    private Processor<Message<?>, ? extends Message<?>> processor;
    private PublisherBuilder<? extends Message<?>> publisher;

    public ProcessorMediator(MediatorConfiguration configuration) {
        super(configuration);
        if (configuration.shape() != Shape.PROCESSOR) {
            throw new IllegalArgumentException("Expected a Processor shape, received a " + configuration.shape());
        }
    }

    @Override
    public void connectToUpstream(PublisherBuilder<? extends Message<?>> publisher) {
        assert (this.processor != null);
        this.publisher = this.decorate(publisher.via(this.processor));
    }

    @Override
    public PublisherBuilder<? extends Message<?>> getStream() {
        return Objects.requireNonNull(this.publisher);
    }

    @Override
    public boolean isConnected() {
        return this.publisher != null;
    }

    @Override
    protected <T> Uni<T> invokeBlocking(Object ... args) {
        return super.invokeBlocking(args).onItem().ifNull().failWith((Throwable)new NullPointerException("The operation " + this.configuration.methodAsString() + " has returned null"));
    }

    @Override
    public void initialize(Object bean) {
        super.initialize(bean);
        switch (this.configuration.production()) {
            case STREAM_OF_MESSAGE: {
                if (this.isReturningAProcessorOrAProcessorBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAProcessorBuilderOfMessages();
                        break;
                    }
                    this.processMethodReturningAProcessorOfMessages();
                    break;
                }
                if (this.isReturningAPublisherOrAPublisherBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAPublisherBuilderOfMessageAndConsumingMessages();
                        break;
                    }
                    this.processMethodReturningAPublisherOfMessageAndConsumingMessages();
                    break;
                }
                throw new IllegalArgumentException("Invalid Processor - unsupported signature for " + this.configuration.methodAsString());
            }
            case STREAM_OF_PAYLOAD: {
                if (this.isReturningAProcessorOrAProcessorBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAProcessorBuilderOfPayloads();
                        break;
                    }
                    this.processMethodReturningAProcessorOfPayloads();
                    break;
                }
                if (this.isReturningAPublisherOrAPublisherBuilder()) {
                    if (this.configuration.usesBuilderTypes()) {
                        this.processMethodReturningAPublisherBuilderOfPayloadsAndConsumingPayloads();
                        break;
                    }
                    this.processMethodReturningAPublisherOfPayloadsAndConsumingPayloads();
                    break;
                }
                throw new IllegalArgumentException("Invalid Processor - unsupported signature for " + this.configuration.methodAsString());
            }
            case INDIVIDUAL_MESSAGE: {
                this.processMethodReturningIndividualMessageAndConsumingIndividualItem();
                break;
            }
            case INDIVIDUAL_PAYLOAD: {
                this.processMethodReturningIndividualPayloadAndConsumingIndividualItem();
                break;
            }
            case COMPLETION_STAGE_OF_MESSAGE: {
                this.processMethodReturningACompletionStageOfMessageAndConsumingIndividualMessage();
                break;
            }
            case COMPLETION_STAGE_OF_PAYLOAD: {
                this.processMethodReturningACompletionStageOfPayloadAndConsumingIndividualPayload();
                break;
            }
            case UNI_OF_MESSAGE: {
                this.processMethodReturningAUniOfMessageAndConsumingIndividualMessage();
                break;
            }
            case UNI_OF_PAYLOAD: {
                this.processMethodReturningAUniOfPayloadAndConsumingIndividualPayload();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected production type: " + this.configuration.production());
            }
        }
    }

    private void processMethodReturningAPublisherBuilderOfMessageAndConsumingMessages() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(msg -> (PublisherBuilder)this.invoke(msg)).flatMap(Function.identity()).buildRs();
    }

    private void processMethodReturningAPublisherOfMessageAndConsumingMessages() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(msg -> (Publisher)this.invoke(msg)).flatMapRsPublisher(Function.identity()).buildRs();
    }

    private void processMethodReturningAProcessorBuilderOfMessages() {
        ProcessorBuilder builder = (ProcessorBuilder)Objects.requireNonNull(this.invoke(new Object[0]), "The method " + this.configuration.methodAsString() + " returned `null`");
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).via(builder).buildRs();
    }

    private void processMethodReturningAProcessorOfMessages() {
        Processor result = (Processor)Objects.requireNonNull(this.invoke(new Object[0]), "The method " + this.configuration.methodAsString() + " returned `null`");
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(msg -> {
            if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.PRE_PROCESSING) {
                return msg.ack().thenApply(x -> msg);
            }
            return CompletableFuture.completedFuture(msg);
        }).via(result).buildRs();
    }

    private void processMethodReturningAProcessorOfPayloads() {
        Processor returnedProcessor = (Processor)this.invoke(new Object[0]);
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(Message::getPayload).via(returnedProcessor).map(Message::of).buildRs();
    }

    private void processMethodReturningAProcessorBuilderOfPayloads() {
        ProcessorBuilder returnedProcessorBuilder = (ProcessorBuilder)this.invoke(new Object[0]);
        Objects.requireNonNull(returnedProcessorBuilder, "The method " + this.configuration.methodAsString() + " has returned an invalid value: null");
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(Message::getPayload).via(returnedProcessorBuilder).map(Message::of).buildRs();
    }

    private void processMethodReturningAPublisherBuilderOfPayloadsAndConsumingPayloads() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMap(message -> {
            PublisherBuilder pb = (PublisherBuilder)this.invoke(message.getPayload());
            return pb.map(payload -> Message.of((Object)payload, (Metadata)message.getMetadata()));
        }).buildRs();
    }

    private void processMethodReturningAPublisherOfPayloadsAndConsumingPayloads() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMap(message -> {
            Publisher pub = (Publisher)this.invoke(message.getPayload());
            return ReactiveStreams.fromPublisher((Publisher)pub).map(payload -> Message.of((Object)payload, (Metadata)message.getMetadata()));
        }).buildRs();
    }

    private void processMethodReturningIndividualMessageAndConsumingIndividualItem() {
        this.processor = this.configuration.consumption() == MediatorConfiguration.Consumption.PAYLOAD ? (this.configuration.isBlocking() ? ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> {
            Uni uni = this.invokeBlocking(input.getPayload());
            if (uni != null) {
                return uni.subscribeAsCompletionStage().thenApply(result -> {
                    if (result != null) {
                        return (Message)result;
                    }
                    throw new NullPointerException("Result of " + this.getMethodAsString() + " was null");
                });
            }
            throw new NullPointerException("Uni returned from " + this.getMethodAsString() + " was null");
        }).buildRs() : ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(input -> (Message)this.invoke(input.getPayload())).buildRs()) : (this.configuration.isBlocking() ? ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> this.invokeBlocking(input).subscribeAsCompletionStage().thenApply(result -> (Message)result)).buildRs() : ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(input -> (Message)this.invoke(input)).buildRs());
    }

    private void processMethodReturningIndividualPayloadAndConsumingIndividualItem() {
        this.processor = this.configuration.consumption() == MediatorConfiguration.Consumption.PAYLOAD ? (this.configuration.isBlocking() ? ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> this.invokeBlocking(input.getPayload()).subscribeAsCompletionStage().thenApply(result -> {
            if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                return input.withPayload(result);
            }
            return Message.of((Object)result, (Metadata)input.getMetadata());
        })).buildRs() : ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(input -> {
            Object result = this.invoke(input.getPayload());
            if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                return input.withPayload(result);
            }
            return Message.of(result, (Metadata)input.getMetadata());
        }).buildRs()) : (this.configuration.isBlocking() ? ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> this.invokeBlocking(input).subscribeAsCompletionStage().thenApply(result -> {
            if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                return Message.of((Object)result, () -> ((Message)input).ack());
            }
            return Message.of((Object)result);
        })).buildRs() : ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).map(input -> {
            Object result = this.invoke(input);
            if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                return Message.of(result, () -> ((Message)input).ack());
            }
            return Message.of(result);
        }).buildRs());
    }

    private void processMethodReturningACompletionStageOfMessageAndConsumingIndividualMessage() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(xva$0 -> (CompletionStage)this.invoke(xva$0)).buildRs();
    }

    private void processMethodReturningAUniOfMessageAndConsumingIndividualMessage() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> {
            Uni uni = (Uni)this.invoke(input);
            return uni.subscribeAsCompletionStage();
        }).buildRs();
    }

    private void processMethodReturningACompletionStageOfPayloadAndConsumingIndividualPayload() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> {
            CompletionStage cs = (CompletionStage)this.invoke(input.getPayload());
            return cs.thenApply(res -> Message.of((Object)res, (Metadata)input.getMetadata(), () -> {
                if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                    return input.ack();
                }
                return CompletableFuture.completedFuture(null);
            }));
        }).buildRs();
    }

    private void processMethodReturningAUniOfPayloadAndConsumingIndividualPayload() {
        this.processor = ReactiveStreams.builder().flatMapCompletionStage(this.managePreProcessingAck()).flatMapCompletionStage(input -> {
            Uni uni = (Uni)this.invoke(input.getPayload());
            return uni.map(res -> Message.of((Object)res, (Metadata)input.getMetadata(), () -> {
                if (this.configuration.getAcknowledgment() == Acknowledgment.Strategy.POST_PROCESSING) {
                    return input.ack();
                }
                return CompletableFuture.completedFuture(null);
            })).subscribeAsCompletionStage();
        }).buildRs();
    }

    private boolean isReturningAPublisherOrAPublisherBuilder() {
        Class returnType = this.configuration.getReturnType();
        return ClassUtils.isAssignable(returnType, Publisher.class) || ClassUtils.isAssignable(returnType, PublisherBuilder.class);
    }

    private boolean isReturningAProcessorOrAProcessorBuilder() {
        Class returnType = this.configuration.getReturnType();
        return ClassUtils.isAssignable(returnType, Processor.class) || ClassUtils.isAssignable(returnType, ProcessorBuilder.class);
    }
}

