/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.extension;

import io.smallrye.reactive.messaging.ChannelRegistry;
import io.smallrye.reactive.messaging.annotations.Blocking;
import io.smallrye.reactive.messaging.annotations.Emitter;
import io.smallrye.reactive.messaging.annotations.Incomings;
import io.smallrye.reactive.messaging.connectors.WorkerPoolRegistry;
import io.smallrye.reactive.messaging.extension.ChannelProducer;
import io.smallrye.reactive.messaging.extension.EmitterImpl;
import io.smallrye.reactive.messaging.extension.MediatorManager;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.ProcessInjectionPoint;
import javax.enterprise.inject.spi.ProcessManagedBean;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.reactive.messaging.Channel;
import org.eclipse.microprofile.reactive.messaging.Incoming;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.eclipse.microprofile.reactive.messaging.Outgoing;
import org.eclipse.microprofile.reactive.streams.operators.PublisherBuilder;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReactiveMessagingExtension
implements Extension {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReactiveMessagingExtension.class);
    private List<MediatorBean<?>> mediatorBeans = new ArrayList();
    private List<InjectionPoint> streamInjectionPoints = new ArrayList<InjectionPoint>();
    private List<InjectionPoint> emitterInjectionPoints = new ArrayList<InjectionPoint>();
    private List<WorkerPoolBean<?>> workerPoolBeans = new ArrayList();

    <T> void processClassesContainingMediators(@Observes ProcessManagedBean<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedBeanClass();
        if (annotatedType.getMethods().stream().anyMatch(m -> m.isAnnotationPresent(Incomings.class) || m.isAnnotationPresent(Incoming.class) || m.isAnnotationPresent(Outgoing.class))) {
            this.mediatorBeans.add(new MediatorBean(event.getBean(), event.getAnnotatedBeanClass()));
        }
    }

    <T> void processBlockingAnnotation(@Observes @WithAnnotations(value={Blocking.class}) ProcessAnnotatedType<T> event) {
        AnnotatedType annotatedType = event.getAnnotatedType();
        this.workerPoolBeans.add(new WorkerPoolBean(annotatedType));
    }

    <T extends Publisher<?>> void processStreamPublisherInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends org.eclipse.microprofile.reactive.messaging.Emitter<?>> void processStreamEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.emitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends Emitter<?>> void processStreamLegacyEmitterInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.emitterInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    <T extends PublisherBuilder<?>> void processStreamPublisherBuilderInjectionPoint(@Observes ProcessInjectionPoint<?, T> pip) {
        Channel stream = ChannelProducer.getChannelQualifier(pip.getInjectionPoint());
        if (stream != null) {
            this.streamInjectionPoints.add(pip.getInjectionPoint());
        }
    }

    /*
     * WARNING - void declaration
     */
    void afterDeploymentValidation(@Observes AfterDeploymentValidation done, BeanManager beanManager) {
        Instance instance = beanManager.createInstance();
        ChannelRegistry registry = (ChannelRegistry)instance.select(ChannelRegistry.class, new Annotation[0]).get();
        HashMap<String, OnOverflow> emitters = new HashMap<String, OnOverflow>();
        for (InjectionPoint injectionPoint : this.emitterInjectionPoints) {
            void var9_16;
            String string = ChannelProducer.getChannelName(injectionPoint);
            OnOverflow onOverflow = (OnOverflow)injectionPoint.getAnnotated().getAnnotation(OnOverflow.class);
            if (onOverflow == null) {
                OnOverflow onOverflow2 = this.createOnOverflowForLegacyAnnotation(injectionPoint);
            }
            emitters.put(string, (OnOverflow)var9_16);
        }
        WorkerPoolRegistry workerPoolRegistry = (WorkerPoolRegistry)instance.select(WorkerPoolRegistry.class, new Annotation[0]).get();
        for (WorkerPoolBean<?> workerPoolBean : this.workerPoolBeans) {
            workerPoolRegistry.analyzeWorker(workerPoolBean.annotatedType);
        }
        MediatorManager mediatorManager = (MediatorManager)instance.select(MediatorManager.class, new Annotation[0]).get();
        mediatorManager.initializeEmitters(emitters);
        for (MediatorBean<?> mediatorBean : this.mediatorBeans) {
            LOGGER.info("Analyzing mediator bean: {}", mediatorBean.bean);
            mediatorManager.analyze(mediatorBean.annotatedType, mediatorBean.bean);
        }
        this.mediatorBeans.clear();
        try {
            String name;
            mediatorManager.initializeAndRun();
            Set set = registry.getIncomingNames();
            for (InjectionPoint ip : this.streamInjectionPoints) {
                name = ChannelProducer.getChannelName(ip);
                if (set.contains(name)) continue;
                done.addDeploymentProblem((Throwable)new DeploymentException("No channel found for name: " + name + ", injection point: " + ip));
            }
            this.streamInjectionPoints.clear();
            for (InjectionPoint ip : this.emitterInjectionPoints) {
                name = ChannelProducer.getChannelName(ip);
                EmitterImpl emitter = (EmitterImpl)registry.getEmitter(name);
                if (emitter.isSubscribed()) continue;
                LOGGER.warn("No subscriber for channel {}  attached to the emitter {}.{}", new Object[]{name, ip.getBean().getBeanClass().getName(), ip.getMember().getName()});
            }
        }
        catch (Exception exception) {
            if (exception.getCause() == null) {
                done.addDeploymentProblem((Throwable)exception);
            }
            done.addDeploymentProblem(exception.getCause());
        }
    }

    private OnOverflow createOnOverflowForLegacyAnnotation(InjectionPoint point) {
        final io.smallrye.reactive.messaging.annotations.OnOverflow legacy = (io.smallrye.reactive.messaging.annotations.OnOverflow)point.getAnnotated().getAnnotation(io.smallrye.reactive.messaging.annotations.OnOverflow.class);
        if (legacy != null) {
            return new OnOverflow(){

                public Class<? extends Annotation> annotationType() {
                    return OnOverflow.class;
                }

                public OnOverflow.Strategy value() {
                    return OnOverflow.Strategy.valueOf((String)legacy.value().name());
                }

                public long bufferSize() {
                    return legacy.bufferSize();
                }
            };
        }
        return null;
    }

    static class WorkerPoolBean<T> {
        final AnnotatedType<T> annotatedType;

        WorkerPoolBean(AnnotatedType<T> annotatedType) {
            this.annotatedType = annotatedType;
        }
    }

    static class MediatorBean<T> {
        final Bean<T> bean;
        final AnnotatedType<T> annotatedType;

        MediatorBean(Bean<T> bean, AnnotatedType<T> annotatedType) {
            this.bean = bean;
            this.annotatedType = annotatedType;
        }
    }
}

