/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.helpers;

public class Validation {
    private Validation() {
    }

    public static <T> T notNull(T instance, String name) {
        if (Validation.isBlank(name)) {
            throw new IllegalArgumentException("`name` must be set");
        }
        if (instance == null) {
            throw new IllegalArgumentException(name + " must not be `null`");
        }
        return instance;
    }

    public static <T> T[] notEmpty(T[] array, String name) {
        if (Validation.isBlank(name)) {
            throw new IllegalArgumentException("`name` must be set");
        }
        if (array == null) {
            throw new IllegalArgumentException(name + " must not be `null`");
        }
        if (array.length == 0) {
            throw new IllegalArgumentException(name + " must not be `empty`");
        }
        return array;
    }

    public static <T> T[] noNullElements(T[] array, String name) {
        if (Validation.isBlank(name)) {
            throw new IllegalArgumentException("`name` must be set");
        }
        if (array == null) {
            throw new IllegalArgumentException(name + " must not be `null`");
        }
        for (T t : array) {
            if (t != null) continue;
            throw new IllegalArgumentException(name + " must not contain a `null` element");
        }
        return array;
    }

    public static boolean isBlank(String string) {
        int strLen;
        if (string == null || (strLen = string.length()) == 0) {
            return true;
        }
        for (int i = 0; i < strLen; ++i) {
            if (Character.isWhitespace(string.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static void isTrue(boolean mustBeTrue, String format, Object ... var) {
        if (!mustBeTrue) {
            throw new IllegalArgumentException(String.format(format, var));
        }
    }
}

