/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.impl;

import io.smallrye.reactive.messaging.i18n.ProviderExceptions;
import io.smallrye.reactive.messaging.i18n.ProviderMessages;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ConnectorConfig
implements Config {
    public static final String CHANNEL_ENABLED_PROPERTY = "enabled";
    private final String prefix;
    private final Config overall;
    private final String name;
    private final String connector;

    protected ConnectorConfig(String prefix, Config overall, String channel) {
        this.prefix = Objects.requireNonNull(prefix, ProviderMessages.msg.prefixMustNotBeSet());
        this.overall = Objects.requireNonNull(overall, ProviderMessages.msg.configMustNotBeSet());
        this.name = Objects.requireNonNull(channel, ProviderMessages.msg.channelMustNotBeSet());
        Optional value = overall.getOptionalValue(this.channelKey("connector"), String.class);
        this.connector = value.orElseGet(() -> (String)overall.getOptionalValue(this.channelKey("type"), String.class).orElseThrow(() -> ProviderExceptions.ex.illegalArgumentChannelConnectorConfiguration(this.name)));
        for (String key : overall.getPropertyNames()) {
            if (!this.channelKey("channel-name").equalsIgnoreCase(key)) continue;
            throw ProviderExceptions.ex.illegalArgumentInvalidChannelConfiguration(this.name);
        }
    }

    private String channelKey(String keyName) {
        return this.name.contains(".") ? this.prefix + "\"" + this.name + "\"." + keyName : this.prefix + this.name + "." + keyName;
    }

    private String connectorKey(String keyName) {
        return "mp.messaging.connector." + this.connector + "." + keyName;
    }

    public <T> T getValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return (T)this.name;
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return (T)this.connector;
        }
        try {
            return (T)this.overall.getValue(this.channelKey(propertyName), propertyType);
        }
        catch (NoSuchElementException e) {
            try {
                return (T)this.overall.getValue(this.connectorKey(propertyName), propertyType);
            }
            catch (NoSuchElementException e2) {
                throw ProviderExceptions.ex.noSuchElementForAttribute(propertyName, this.name, this.channelKey(propertyName), this.connectorKey(propertyName));
            }
        }
    }

    public <T> Optional<T> getOptionalValue(String propertyName, Class<T> propertyType) {
        if ("channel-name".equalsIgnoreCase(propertyName)) {
            return Optional.of(this.name);
        }
        if ("connector".equalsIgnoreCase(propertyName) || "type".equalsIgnoreCase(propertyName)) {
            return Optional.of(this.connector);
        }
        Optional maybe = this.overall.getOptionalValue(this.channelKey(propertyName), propertyType);
        return maybe.isPresent() ? maybe : this.overall.getOptionalValue(this.connectorKey(propertyName), propertyType);
    }

    public Iterable<String> getPropertyNames() {
        Set<String> strings = StreamSupport.stream(this.overall.getPropertyNames().spliterator(), false).filter(s -> s.startsWith("mp.messaging.connector." + this.connector + ".")).map(s -> s.substring(("mp.messaging.connector." + this.connector + ".").length())).collect(Collectors.toSet());
        StreamSupport.stream(this.overall.getPropertyNames().spliterator(), false).filter(s -> s.startsWith(this.prefix + this.name + ".")).map(s -> s.substring((this.prefix + this.name + ".").length())).forEach(strings::add);
        strings.add("channel-name");
        return strings;
    }

    public Iterable<ConfigSource> getConfigSources() {
        return this.overall.getConfigSources();
    }
}

