/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.messaging.i18n;

import io.smallrye.reactive.messaging.MediatorConfiguration;
import io.smallrye.reactive.messaging.ProcessingException;
import io.smallrye.reactive.messaging.Shape;
import io.smallrye.reactive.messaging.WeavingException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.enterprise.inject.spi.InjectionPoint;
import org.eclipse.microprofile.config.spi.Converter;
import org.eclipse.microprofile.reactive.messaging.OnOverflow;
import org.jboss.logging.Messages;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageBundle;

@MessageBundle(projectCode="SRMSG", length=5)
public interface ProviderExceptions {
    public static final ProviderExceptions ex = (ProviderExceptions)Messages.getBundle(ProviderExceptions.class);

    @Message(id=0, value="%s")
    public ProcessingException processingException(String var1, @Cause Throwable var2);

    @Message(id=1, value="Method %s only has %d so parameter with index %d cannot be retrieved")
    public IllegalArgumentException illegalArgumentForGenericParameterType(Method var1, int var2, int var3);

    @Message(id=2, value="Invalid method annotated with %s: %s - value is blank or null")
    public IllegalArgumentException illegalArgumentForAnnotationNullOrBlank(String var1, String var2);

    @Message(id=3, value="Unknown shape: %s")
    public IllegalStateException illegalStateExceptionForValidate(Shape var1);

    @Message(id=4, value="Invalid method annotated with @Outgoing and @Incoming %s - one parameter expected")
    public IllegalArgumentException illegalArgumentForValidateProcessor(String var1);

    @Message(id=5, value="Unsupported acknowledgement policy - POST_PROCESSING not supported when producing messages for %s")
    public IllegalStateException illegalStateForValidateProcessor(String var1);

    @Message(id=6, value="Invalid method annotated with %s: %s - The @Acknowledgment annotation is only supported for method annotated with @Incoming")
    public DefinitionException definitionExceptionUnsupported(String var1, String var2);

    @Message(id=7, value="Unsupported shape %s for method %s")
    public IllegalArgumentException illegalArgumentForUnsupportedShape(Shape var1, String var2);

    @Message(id=8, value="Expected a Processor shape, received a %s")
    public IllegalArgumentException illegalArgumentForProcessorShape(Shape var1);

    @Message(id=9, value="Invalid Processor - unsupported signature for %s")
    public IllegalArgumentException illegalArgumentForInitialize(String var1);

    @Message(id=10, value="Unexpected production type: %s")
    public IllegalArgumentException illegalArgumentForUnexpectedProduction(MediatorConfiguration.Production var1);

    @Message(id=11, value="Expected a Publisher shape, received a %s")
    public IllegalArgumentException illegalArgumentForPublisherShape(Shape var1);

    @Message(id=12, value="Unexpected consumption type: %s")
    public IllegalArgumentException illegalArgumentForUnexpectedConsumption(MediatorConfiguration.Consumption var1);

    @Message(id=13, value="Expected a Subscriber shape, received a %s")
    public IllegalArgumentException illegalArgumentForSubscriberShape(Shape var1);

    @Message(id=14, value="%s")
    public WeavingException weavingForIncoming(List<String> var1, @Cause Throwable var2);

    @Message(id=15, value="Invalid return type: %s - expected a Subscriber or a SubscriberBuilder")
    public IllegalStateException illegalStateExceptionForSubscriberOrSubscriberBuilder(String var1);

    @Message(id=16, value="Failed to create Worker for %s")
    public RuntimeException runtimeForFailedWorker(String var1);

    @Message(id=17, value="@Blocking referred to invalid worker name.")
    public IllegalArgumentException illegalArgumentForFailedWorker();

    @Message(id=18, value="Unable to find a stream with the name %s, available streams are: %s")
    public IllegalStateException illegalStateForStream(String var1, Set<String> var2);

    @Message(id=19, value="Unable to connect an emitter with the channel `%s`")
    public DefinitionException incomingNotFoundForEmitter(String var1);

    @Message(id=20, value="Missing @Channel qualifier for + `%s`")
    public DefinitionException emitterWithoutChannelAnnotation(InjectionPoint var1);

    @Message(id=21, value="The default buffer size must be strictly positive")
    public IllegalArgumentException illegalArgumentForDefaultBuffer();

    @Message(id=22, value="Invalid back-pressure strategy: %s")
    public IllegalArgumentException illegalArgumentForBackPressure(OnOverflow.Strategy var1);

    @Message(id=23, value="`null` is not a valid value")
    public IllegalArgumentException illegalArgumentForNullValue();

    @Message(id=24, value="The emitter encountered a failure")
    public IllegalStateException incomingNotFoundForEmitter(@Cause Throwable var1);

    @Message(id=25, value="The downstream has cancelled the consumption")
    public IllegalStateException illegalStateForDownstreamCancel();

    @Message(id=26, value="The emitter encountered a failure while emitting")
    public IllegalStateException illegalStateForEmitterWhileEmitting(@Cause Throwable var1);

    @Message(id=27, value="No subscriber found for the channel %s")
    public IllegalStateException illegalStateForNoSubscriber(String var1);

    @Message(id=28, value="The subscription to %s has been cancelled")
    public IllegalStateException illegalStateForCancelledSubscriber(String var1);

    @Message(id=29, value="`%s` is not a valid exception")
    public IllegalArgumentException illegalArgumentForException(String var1);

    @Message(id=34, value="Insufficient downstream requests to emit item")
    public IllegalStateException illegalStateInsufficientDownstreamRequests();

    @Message(id=35, value="found an unhandled type: %s")
    public IllegalStateException illegalStateUnhandledType(Type var1);

    @Message(id=36, value="missing assignment type for type variable %s")
    public IllegalArgumentException illegalArgumentMissingAssignment(Type var1);

    @Message(id=37, value="Unexpected generic interface type found: %s")
    public IllegalStateException illegalStateUnexpectedGenericInterface(Type var1);

    @Message(id=38, value="%s")
    public IllegalArgumentException illegalArgumentTypeToString(String var1);

    @Message(id=39, value="`name` must be set")
    public IllegalArgumentException nameMustBeSet();

    @Message(id=40, value="%s must not be `null`")
    public IllegalArgumentException validationForNotNull(String var1);

    @Message(id=41, value="%s must not be `empty`")
    public IllegalArgumentException validationForNotEmpty(String var1);

    @Message(id=42, value="%s must not contain a `null` element")
    public IllegalArgumentException validationForContainsNull(String var1);

    @Message(id=43, value="%s")
    public IllegalArgumentException validateIsTrue(String var1);

    @Message(id=44, value="Invalid channel configuration -  the `channel-name` attribute cannot be used in configuration (channel `%s`)")
    public IllegalArgumentException illegalArgumentInvalidChannelConfiguration(String var1);

    @Message(id=45, value="Cannot find attribute `%s` for channel `%s`. Has been tried: % and %s")
    public NoSuchElementException noSuchElementForAttribute(String var1, String var2, String var3, String var4);

    @Message(id=46, value="%ss must contain a non-empty array of %s")
    public IllegalArgumentException illegalArgumentForAnnotationNonEmpty(String var1, String var2);

    @Message(id=47, value="Invalid method annotated with %s: %s - when returning a Subscriber or a SubscriberBuilder, no parameters are expected")
    public DefinitionException definitionNoParamOnSubscriber(String var1, String var2);

    @Message(id=48, value="Invalid method annotated with %s: %s - the returned Subscriber must declare a type parameter")
    public DefinitionException definitionSubscriberTypeParam(String var1, String var2);

    @Message(id=49, value="Invalid method annotated with %s: %s - when returning a %s, one parameter is expected")
    public DefinitionException definitionOnParam(String var1, String var2, String var3);

    @Message(id=50, value="Invalid method annotated with %s: %s - Unsupported signature")
    public DefinitionException definitionUnsupportedSignature(String var1, String var2);

    @Message(id=51, value="Invalid method annotated with @Incoming: %s - The signature is not supported. The method consumes a `Message`, so the returned type must be `CompletionStage<Void>` or `Uni<Void>`.")
    public DefinitionException unsupportedSynchronousSignature(String var1);

    @Message(id=52, value="Invalid method annotated with %s: %s - the method must not be `void`")
    public DefinitionException definitionNotVoid(String var1, String var2);

    @Message(id=53, value="Invalid method annotated with %s: %s - no parameters expected")
    public DefinitionException definitionNoParametersExpected(String var1, String var2);

    @Message(id=54, value="Invalid method annotated with %s: %s - the returned %s must declare a type parameter")
    public DefinitionException definitionMustDeclareParam(String var1, String var2, String var3);

    @Message(id=55, value="Invalid method annotated with %s: %s - the method must not have parameters")
    public DefinitionException definitionMustNotHaveParams(String var1, String var2);

    @Message(id=56, value="Invalid method annotated with %s: %s - Expected 2 type parameters for the returned Processor")
    public DefinitionException definitionExpectedTwoParams(String var1, String var2);

    @Message(id=57, value="Invalid method annotated with %s: %s - Expected a type parameter in the returned %s")
    public DefinitionException definitionExpectedReturnedParam(String var1, String var2, String var3);

    @Message(id=58, value="Invalid method annotated with %s: %s - Expected a type parameter for the consumed  %s")
    public DefinitionException definitionExpectedConsumedParam(String var1, String var2, String var3);

    @Message(id=59, value="Invalid method annotated with %s: %s - Automatic post-processing acknowledgment is not supported.")
    public DefinitionException definitionAutoAckNotSupported(String var1, String var2);

    @Message(id=60, value="Invalid method annotated with %s: %s - Consuming a stream of payload is not supported with MANUAL acknowledgment. Use a Publisher<Message<I>> or PublisherBuilder<Message<I>> instead.")
    public DefinitionException definitionManualAckNotSupported(String var1, String var2);

    @Message(id=61, value="Invalid method annotated with %s: %s - If the method produces a PublisherBuilder, it needs to consume a PublisherBuilder.")
    public DefinitionException definitionProduceConsume(String var1, String var2);

    @Message(id=62, value="Invalid method annotated with %s: %s - The @Merge annotation is only supported for method annotated with @Incoming")
    public DefinitionException definitionMergeOnlyIncoming(String var1, String var2);

    @Message(id=63, value="Invalid method annotated with %s: %s - The @Broadcast annotation is only supported for method annotated with @Outgoing")
    public DefinitionException definitionBroadcastOnlyOutgoing(String var1, String var2);

    @Message(id=64, value="Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods returning `void` (@Incoming only), a `Message` or a payload")
    public DefinitionException definitionBlockingOnlyIndividual(String var1);

    @Message(id=65, value="Invalid method annotated with @Blocking: %s - The @Blocking annotation is only supported for methods consuming an individual Message or payload like `consume(String s)` or `consume(Message<String> s)")
    public DefinitionException definitionBlockingOnlyIndividualParam(String var1);

    @Message(id=66, value="Invalid method annotated with @Blocking: %s - no @Incoming or @Outgoing present")
    public IllegalArgumentException illegalBlockingSignature(String var1);

    @Message(id=67, value="Invalid method annotated with %s: %s - %s was not defined")
    public IllegalArgumentException illegalArgumentForWorkerConfigKey(String var1, String var2, String var3);

    @Message(id=68, value="The operation %s has returned null")
    public NullPointerException nullPointerOnInvokeBlocking(String var1);

    @Message(id=69, value="%s not supported")
    public IllegalStateException illegalStateForNotSupported(String var1);

    @Message(id=71, value="Invalid channel configuration -  the `connector` attribute must be set for channel `%s`")
    public IllegalArgumentException illegalArgumentChannelConnectorConfiguration(String var1);

    @Message(id=72, value="Unknown connector for `%s`.")
    public IllegalArgumentException illegalArgumentUnknownConnector(String var1);

    @Message(id=73, value="Invalid configuration, the following channel names cannot be used for both incoming and outgoing: %s")
    public DeploymentException deploymentInvalidConfiguration(Set<String> var1);

    @Message(id=74, value="Unable to retrieve the config")
    public IllegalStateException illegalStateRetrieveConfig();

    @Message(id=75, value="Invalid Emitter injection found for `%s`. Injecting an `Emitter<Message<T>>` is invalid. You can use an `Emitter<T>` to send instances of `T` and `Message<T>`.")
    public DefinitionException invalidEmitterOfMessage(InjectionPoint var1);

    @Message(id=76, value="Invalid Emitter injection found for  `%s`. The Emitter expected to be parameterized with the emitted type, such as Emitter<String>.")
    public DefinitionException invalidRawEmitter(InjectionPoint var1);

    @Message(id=77, value="No converter for type `%s`")
    public NoSuchElementException noConverterForType(Class<?> var1);

    @Message(id=78, value="Converter `%s` returned null for value `%s`")
    public NoSuchElementException converterReturnedNull(Converter<?> var1, String var2);

    @Message(id=79, value="The config is not of type `%s`")
    public IllegalArgumentException configNotOfType(Class<?> var1);

    @Message(id=80, value="Invalid method annotated with @Incoming: %s - when returning a CompletionStage, you must return a CompletionStage<Void>")
    public DefinitionException definitionCompletionStageOfVoid(String var1);

    @Message(id=81, value="Invalid method annotated with @Incoming: %s. The signature is not supported as the produced result would be ignored. The method must return `void`, found %s.")
    public DefinitionException definitionReturnVoid(String var1, String var2);
}

