package io.smallrye.reactive.messaging.i18n;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import java.lang.String;
import org.jboss.logging.Logger;
import javax.enterprise.inject.spi.Bean;
import java.lang.Integer;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.Class;
import java.util.List;
import io.smallrye.reactive.messaging.wiring.Wiring.Component;


import static org.jboss.logging.Logger.Level.ERROR;
import static org.jboss.logging.Logger.Level.INFO;
import static org.jboss.logging.Logger.Level.DEBUG;
import static org.jboss.logging.Logger.Level.WARN;

/**
 * Warning this class consists of generated code.
 */
public class ProviderLogging_$logger extends DelegatingBasicLogger implements ProviderLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = ProviderLogging_$logger.class.getName();
    public ProviderLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void methodException(final String methodAsString, final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, methodException$str(), methodAsString);
    }
    protected String methodException$str() {
        return "SRMSG00200: The method %s has thrown an exception";
    }
    @Override
    public final void messageProcessingException(final Throwable cause) {
        super.log.logf(FQCN, ERROR, cause, messageProcessingException$str());
    }
    protected String messageProcessingException$str() {
        return "SRMSG00201: Error caught while processing a message";
    }
    @Override
    public final void vertXInstanceCreated() {
        super.log.logf(FQCN, INFO, null, vertXInstanceCreated$str());
    }
    protected String vertXInstanceCreated$str() {
        return "SRMSG00202: Created new Vertx instance";
    }
    @Override
    public final void workerPoolCreated(final String workerName, final Integer count) {
        super.log.logf(FQCN, INFO, null, workerPoolCreated$str(), workerName, count);
    }
    protected String workerPoolCreated$str() {
        return "SRMSG00203: Created worker pool named %s with concurrency of %d";
    }
    @Override
    public final void multiplePublisherFound(final String source) {
        super.log.logf(FQCN, WARN, null, multiplePublisherFound$str(), source);
    }
    protected String multiplePublisherFound$str() {
        return "SRMSG00204: Multiple publisher found for %s, using the merge policy `ONE` takes the first found";
    }
    @Override
    public final void strictModeEnabled() {
        super.log.logf(FQCN, DEBUG, null, strictModeEnabled$str());
    }
    protected String strictModeEnabled$str() {
        return "SRMSG00205: Strict mode enabled";
    }
    @Override
    public final void scanningType(final Class<?> javaClass) {
        super.log.logf(FQCN, DEBUG, null, scanningType$str(), javaClass);
    }
    protected String scanningType$str() {
        return "SRMSG00206: Scanning Type: %s";
    }
    @Override
    public final void reportWiringFailures(final String message) {
        super.log.logf(FQCN, WARN, null, reportWiringFailures$str(), message);
    }
    protected String reportWiringFailures$str() {
        return "SRMSG00207: %s";
    }
    @Override
    public final void connectorWithoutDownstream(final Component component) {
        super.log.logf(FQCN, WARN, null, connectorWithoutDownstream$str(), component);
    }
    protected String connectorWithoutDownstream$str() {
        return "SRMSG00208: The connector '%s' has no downstreams";
    }
    @Override
    public final void startGraphResolution(final int size) {
        super.log.logf(FQCN, DEBUG, null, startGraphResolution$str(), size);
    }
    protected String startGraphResolution$str() {
        return "SRMSG00209: Beginning graph resolution, number of components detected: %d";
    }
    @Override
    public final void completedGraphResolution(final long duration) {
        super.log.logf(FQCN, DEBUG, null, completedGraphResolution$str(), duration);
    }
    protected String completedGraphResolution$str() {
        return "SRMSG00210: Graph resolution completed in %d ns";
    }
    @Override
    public final void unableToCreateInvoker(final Class<?> invokerClass, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreateInvoker$str(), invokerClass);
    }
    protected String unableToCreateInvoker$str() {
        return "SRMSG00211: Unable to create invoker instance of %s";
    }
    @Override
    public final void unableToInitializeMediator(final String methodAsString, final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToInitializeMediator$str(), methodAsString);
    }
    protected String unableToInitializeMediator$str() {
        return "SRMSG00212: Unable to initialize mediator: %s";
    }
    @Override
    public final void analyzingMediatorBean(final Bean<?> bean) {
        super.log.logf(FQCN, INFO, null, analyzingMediatorBean$str(), bean);
    }
    protected String analyzingMediatorBean$str() {
        return "SRMSG00224: Analyzing mediator bean: %s";
    }
    @Override
    public final void foundIncomingConnectors(final List<String> connectors) {
        super.log.logf(FQCN, DEBUG, null, foundIncomingConnectors$str(), connectors);
    }
    protected String foundIncomingConnectors$str() {
        return "SRMSG00226: Found incoming connectors: %s";
    }
    @Override
    public final void foundOutgoingConnectors(final List<String> connectors) {
        super.log.logf(FQCN, DEBUG, null, foundOutgoingConnectors$str(), connectors);
    }
    protected String foundOutgoingConnectors$str() {
        return "SRMSG00227: Found outgoing connectors: %s";
    }
    @Override
    public final void skippingMPConfig() {
        super.log.logf(FQCN, INFO, null, skippingMPConfig$str());
    }
    protected String skippingMPConfig$str() {
        return "SRMSG00228: No MicroProfile Config found, skipping";
    }
    @Override
    public final void channelManagerInitializing() {
        super.log.logf(FQCN, DEBUG, null, channelManagerInitializing$str());
    }
    protected String channelManagerInitializing$str() {
        return "SRMSG00229: Channel manager initializing...";
    }
    @Override
    public final void unableToCreatePublisherOrSubscriber(final Throwable t) {
        super.log.logf(FQCN, ERROR, t, unableToCreatePublisherOrSubscriber$str());
    }
    protected String unableToCreatePublisherOrSubscriber$str() {
        return "SRMSG00230: Unable to create the publisher or subscriber during initialization";
    }
    @Override
    public final void incomingChannelDisabled(final String channel) {
        super.log.logf(FQCN, INFO, null, incomingChannelDisabled$str(), channel);
    }
    protected String incomingChannelDisabled$str() {
        return "SRMSG00231: Incoming channel `%s` disabled by configuration";
    }
    @Override
    public final void outgoingChannelDisabled(final String channel) {
        super.log.logf(FQCN, INFO, null, outgoingChannelDisabled$str(), channel);
    }
    protected String outgoingChannelDisabled$str() {
        return "SRMSG00232: Outgoing channel `%s` disabled by configuration";
    }
    @Override
    public final void unableToExtractIngestedPayloadType(final String method, final String reason) {
        super.log.logf(FQCN, WARN, null, unableToExtractIngestedPayloadType$str(), method, reason);
    }
    protected String unableToExtractIngestedPayloadType$str() {
        return "SRMSG00233: Unable to extract the ingested payload type for method `%s`, the reason is: %s";
    }
    @Override
    public final void failureEmittingMessage(final Throwable t) {
        super.log.logf(FQCN, WARN, t, failureEmittingMessage$str());
    }
    protected String failureEmittingMessage$str() {
        return "SRMSG00234: Failed to emit a Message to the channel";
    }
    @Override
    public final void startMaterialization() {
        super.log.logf(FQCN, DEBUG, null, startMaterialization$str());
    }
    protected String startMaterialization$str() {
        return "SRMSG00235: Beginning materialization";
    }
    @Override
    public final void materializationCompleted(final long duration) {
        super.log.logf(FQCN, DEBUG, null, materializationCompleted$str(), duration);
    }
    protected String materializationCompleted$str() {
        return "SRMSG00236: Materialization completed in %d ns";
    }
    @Override
    public final void deprecatedNamed() {
        if (super.log.isEnabled(WARN) && deprecatedNamed_$Once.compareAndSet(false, true)) {
            super.log.logf(FQCN, WARN, null, deprecatedNamed$str());
        }
    }
    protected String deprecatedNamed$str() {
        return "SRMSG00237: Use of @javax.inject.Named in Reactive Messaging is deprecated, use @io.smallrye.common.annotation.Identifier instead";
    }
    private static final AtomicBoolean deprecatedNamed_$Once = new AtomicBoolean(false);
    @Override
    public final void noExecutionHolderDisablingBlockingSupport() {
        super.log.logf(FQCN, INFO, null, noExecutionHolderDisablingBlockingSupport$str());
    }
    protected String noExecutionHolderDisablingBlockingSupport$str() {
        return "SRMSG00238: No ExecutionHolder, disabling @Blocking support";
    }
}
