package io.smallrye.reactive.messaging.rabbitmq.i18n;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.Throwable;
import java.lang.String;
import java.util.Arrays;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class RabbitMQExceptions_$bundle implements RabbitMQExceptions, Serializable {
    private static final long serialVersionUID = 1L;
    protected RabbitMQExceptions_$bundle() {}
    public static final RabbitMQExceptions_$bundle INSTANCE = new RabbitMQExceptions_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String illegalStateFindingBean$str() {
        return "SRMSG16000: Cannot find a %s bean named %s";
    }
    @Override
    public final IllegalStateException illegalStateFindingBean(final String className, final String beanName) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateFindingBean$str(), className, beanName));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String illegalStateConsumeWithoutBackPressure$str() {
        return "SRMSG16001: Expecting downstream to consume without back-pressure";
    }
    @Override
    public final IllegalStateException illegalStateConsumeWithoutBackPressure() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateConsumeWithoutBackPressure$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidFailureStrategy$str() {
        return "SRMSG16002: Invalid failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateConnectionDisconnected$str() {
        return "SRMSG16003: AMQP Connection disconnected";
    }
    @Override
    public final IllegalStateException illegalStateConnectionDisconnected() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateConnectionDisconnected$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentUnknownFailureStrategy$str() {
        return "SRMSG16004: Unknown failure strategy: %s";
    }
    @Override
    public final IllegalArgumentException illegalArgumentUnknownFailureStrategy(final String strategy) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentUnknownFailureStrategy$str(), strategy));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateOnlyOneSubscriberAllowed$str() {
        return "SRMSG16005: Only one subscriber allowed";
    }
    @Override
    public final IllegalStateException illegalStateOnlyOneSubscriberAllowed() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateOnlyOneSubscriberAllowed$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidMaxInflightMessages$str() {
        return "SRMSG16006: The value of max-inflight-messages must be greater than 0";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidMaxInflightMessages() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidMaxInflightMessages$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidDefaultTtl$str() {
        return "SRMSG16007: If specified, the value of default-ttl must be greater than or equal to 0";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidDefaultTtl() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidDefaultTtl$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalArgumentInvalidQueueTtl$str() {
        return "SRMSG16008: If specified, the value of queue.ttl must be greater than or equal to 0";
    }
    @Override
    public final IllegalArgumentException illegalArgumentInvalidQueueTtl() {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), illegalArgumentInvalidQueueTtl$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String illegalStateUnableToCreateClient$str() {
        return "SRMSG16009: Unable to create a client, probably a config error";
    }
    @Override
    public final IllegalStateException illegalStateUnableToCreateClient(final Throwable t) {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), illegalStateUnableToCreateClient$str()), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
}
