/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.SecuritySupport;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import org.eclipse.microprofile.config.spi.Converter;

class Converters {
    static final Converter<String> STRING_CONVERTER = (Converter & Serializable)value -> value;
    static final Converter<Boolean> BOOLEAN_CONVERTER = (Converter & Serializable)value -> {
        if (value != null) {
            return "TRUE".equalsIgnoreCase(value) || "1".equalsIgnoreCase(value) || "YES".equalsIgnoreCase(value) || "Y".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "JA".equalsIgnoreCase(value) || "J".equalsIgnoreCase(value) || "SI".equalsIgnoreCase(value) || "SIM".equalsIgnoreCase(value) || "OUI".equalsIgnoreCase(value);
        }
        return null;
    };
    static final Converter<Double> DOUBLE_CONVERTER = (Converter & Serializable)value -> value != null ? Double.valueOf(value) : null;
    static final Converter<Float> FLOAT_CONVERTER = (Converter & Serializable)value -> value != null ? Float.valueOf(value) : null;
    static final Converter<Long> LONG_CONVERTER = (Converter & Serializable)value -> value != null ? Long.valueOf(value) : null;
    static final Converter<Integer> INTEGER_CONVERTER = (Converter & Serializable)value -> value != null ? Integer.valueOf(value) : null;
    static final Converter<Class<?>> CLASS_CONVERTER = (Converter & Serializable)value -> {
        try {
            return value != null ? Class.forName(value, true, SecuritySupport.getContextClassLoader()) : null;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException(e);
        }
    };
    static final Converter<OptionalInt> OPTIONAL_INT_CONVERTER = (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalInt.of(Integer.parseInt(value)) : OptionalInt.empty();
    static final Converter<OptionalLong> OPTIONAL_LONG_CONVERTER = (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalLong.of(Long.parseLong(value)) : OptionalLong.empty();
    static final Converter<OptionalDouble> OPTIONAL_DOUBLE_CONVERTER = (Converter & Serializable)value -> value != null && !value.isEmpty() ? OptionalDouble.of(Double.parseDouble(value)) : OptionalDouble.empty();
    public static final Map<Type, Converter> ALL_CONVERTERS = new HashMap<Type, Converter>();

    Converters() {
    }

    static {
        ALL_CONVERTERS.put((Type)((Object)String.class), (Converter)STRING_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Boolean.class), (Converter)BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put(Boolean.TYPE, BOOLEAN_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Double.class), (Converter)DOUBLE_CONVERTER);
        ALL_CONVERTERS.put(Double.TYPE, DOUBLE_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Float.class), (Converter)FLOAT_CONVERTER);
        ALL_CONVERTERS.put(Float.TYPE, FLOAT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Long.class), (Converter)LONG_CONVERTER);
        ALL_CONVERTERS.put(Long.TYPE, LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Integer.class), (Converter)INTEGER_CONVERTER);
        ALL_CONVERTERS.put(Integer.TYPE, INTEGER_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)Class.class), (Converter)CLASS_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalInt.class), (Converter)OPTIONAL_INT_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalLong.class), (Converter)OPTIONAL_LONG_CONVERTER);
        ALL_CONVERTERS.put((Type)((Object)OptionalDouble.class), (Converter)OPTIONAL_DOUBLE_CONVERTER);
    }
}

