/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.faulttolerance;

import io.smallrye.faulttolerance.DefaultMethodFallbackProvider;
import io.smallrye.faulttolerance.ExecutionContextWithInvocationContext;
import io.smallrye.faulttolerance.ExecutorProvider;
import io.smallrye.faulttolerance.FallbackHandlerProvider;
import io.smallrye.faulttolerance.FaultToleranceBinding;
import io.smallrye.faulttolerance.FaultToleranceOperationProvider;
import io.smallrye.faulttolerance.SecurityActions;
import io.smallrye.faulttolerance.api.CircuitBreakerStateChanged;
import io.smallrye.faulttolerance.config.BulkheadConfig;
import io.smallrye.faulttolerance.config.CircuitBreakerConfig;
import io.smallrye.faulttolerance.config.FallbackConfig;
import io.smallrye.faulttolerance.config.FaultToleranceOperation;
import io.smallrye.faulttolerance.config.GenericConfig;
import io.smallrye.faulttolerance.config.RetryConfig;
import io.smallrye.faulttolerance.core.FaultToleranceStrategy;
import io.smallrye.faulttolerance.core.GeneralMetrics;
import io.smallrye.faulttolerance.core.GeneralMetricsRecorder;
import io.smallrye.faulttolerance.core.Invocation;
import io.smallrye.faulttolerance.core.InvocationContext;
import io.smallrye.faulttolerance.core.async.FutureExecution;
import io.smallrye.faulttolerance.core.bulkhead.BulkheadBase;
import io.smallrye.faulttolerance.core.bulkhead.CompletionStageBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.SemaphoreBulkhead;
import io.smallrye.faulttolerance.core.bulkhead.ThreadPoolBulkhead;
import io.smallrye.faulttolerance.core.circuit.breaker.CircuitBreaker;
import io.smallrye.faulttolerance.core.circuit.breaker.CompletionStageCircuitBreaker;
import io.smallrye.faulttolerance.core.fallback.CompletionStageFallback;
import io.smallrye.faulttolerance.core.fallback.Fallback;
import io.smallrye.faulttolerance.core.fallback.FallbackFunction;
import io.smallrye.faulttolerance.core.retry.CompletionStageRetry;
import io.smallrye.faulttolerance.core.retry.Delay;
import io.smallrye.faulttolerance.core.retry.Jitter;
import io.smallrye.faulttolerance.core.retry.RandomJitter;
import io.smallrye.faulttolerance.core.retry.Retry;
import io.smallrye.faulttolerance.core.retry.ThreadSleepDelay;
import io.smallrye.faulttolerance.core.stopwatch.Stopwatch;
import io.smallrye.faulttolerance.core.stopwatch.SystemStopwatch;
import io.smallrye.faulttolerance.core.timeout.AsyncTimeout;
import io.smallrye.faulttolerance.core.timeout.CompletionStageTimeout;
import io.smallrye.faulttolerance.core.timeout.ScheduledExecutorTimeoutWatcher;
import io.smallrye.faulttolerance.core.timeout.Timeout;
import io.smallrye.faulttolerance.core.timeout.TimeoutWatcher;
import io.smallrye.faulttolerance.core.util.CompletionStages;
import io.smallrye.faulttolerance.core.util.SetOfThrowables;
import io.smallrye.faulttolerance.core.util.SneakyThrow;
import io.smallrye.faulttolerance.internal.CircuitBreakerStateObserver;
import io.smallrye.faulttolerance.internal.InterceptionPoint;
import io.smallrye.faulttolerance.internal.RequestContextControllerProvider;
import io.smallrye.faulttolerance.internal.RequestScopeActivator;
import io.smallrye.faulttolerance.internal.StrategyCache;
import io.smallrye.faulttolerance.metrics.MetricsCollector;
import io.smallrye.faulttolerance.metrics.MetricsCollectorFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import javax.annotation.Priority;
import javax.enterprise.context.control.RequestContextController;
import javax.enterprise.event.Event;
import javax.enterprise.inject.Intercepted;
import javax.enterprise.inject.spi.Bean;
import javax.inject.Inject;
import javax.interceptor.AroundInvoke;
import javax.interceptor.Interceptor;
import org.eclipse.microprofile.faulttolerance.ExecutionContext;
import org.eclipse.microprofile.faulttolerance.Fallback;
import org.eclipse.microprofile.faulttolerance.FallbackHandler;
import org.eclipse.microprofile.faulttolerance.exceptions.FaultToleranceException;
import org.jboss.logging.Logger;

@Interceptor
@FaultToleranceBinding
@Priority(value=4010)
public class FaultToleranceInterceptor {
    private static final Logger LOGGER = Logger.getLogger(FaultToleranceInterceptor.class);
    private final FallbackHandlerProvider fallbackHandlerProvider;
    private final Bean<?> interceptedBean;
    private final MetricsCollectorFactory metricsCollectorFactory;
    private final ScheduledExecutorService timeoutExecutor;
    private final ExecutorService asyncExecutor;
    private final FaultToleranceOperationProvider operationProvider;
    private final ExecutorProvider executorProvider;
    private final StrategyCache cache;
    private final RequestContextController requestContextController;
    private final Event<CircuitBreakerStateChanged> cbStateEvent;

    @Inject
    public FaultToleranceInterceptor(FallbackHandlerProvider fallbackHandlerProvider, @Intercepted Bean<?> interceptedBean, MetricsCollectorFactory metricsCollectorFactory, FaultToleranceOperationProvider operationProvider, StrategyCache cache, ExecutorProvider executorProvider, Event<CircuitBreakerStateChanged> cbStateEvent) {
        this.fallbackHandlerProvider = fallbackHandlerProvider;
        this.interceptedBean = interceptedBean;
        this.metricsCollectorFactory = metricsCollectorFactory;
        this.operationProvider = operationProvider;
        this.executorProvider = executorProvider;
        this.cache = cache;
        this.cbStateEvent = cbStateEvent;
        this.asyncExecutor = executorProvider.getGlobalExecutor();
        this.timeoutExecutor = executorProvider.getTimeoutExecutor();
        this.requestContextController = RequestContextControllerProvider.load().get();
    }

    @AroundInvoke
    public Object interceptCommand(javax.interceptor.InvocationContext invocationContext) throws Exception {
        Method method = invocationContext.getMethod();
        Class beanClass = this.interceptedBean != null ? this.interceptedBean.getBeanClass() : method.getDeclaringClass();
        InterceptionPoint point = new InterceptionPoint(beanClass, invocationContext);
        FaultToleranceOperation operation = this.operationProvider.get(beanClass, method);
        MetricsCollector collector = this.getMetricsCollector(operation, point);
        if (operation.isAsync() && operation.returnsCompletionStage()) {
            return this.properAsyncFlow(operation, invocationContext, collector, point);
        }
        if (operation.isAsync()) {
            return this.futureFlow(operation, invocationContext, collector, point);
        }
        return this.syncFlow(operation, invocationContext, collector, point);
    }

    private <T> CompletionStage<T> properAsyncFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext invocationContext, MetricsCollector collector, InterceptionPoint point) {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, ignored -> this.prepareAsyncStrategy(operation, point, collector));
        try {
            collector.invoked();
            InvocationContext ctx = new InvocationContext(() -> {
                CompletableFuture result = new CompletableFuture();
                this.asyncExecutor.submit(() -> {
                    try {
                        this.requestContextController.activate();
                        CompletionStages.propagateCompletion((CompletionStage)((CompletionStage)invocationContext.proceed()), (CompletableFuture)result);
                    }
                    catch (Exception any) {
                        result.completeExceptionally(any);
                    }
                    finally {
                        this.requestContextController.deactivate();
                    }
                });
                return result;
            });
            ctx.set(javax.interceptor.InvocationContext.class, (Object)invocationContext);
            return ((CompletionStage)strategy.apply(ctx)).exceptionally(e -> {
                collector.failed();
                throw SneakyThrow.sneakyThrow((Throwable)e);
            });
        }
        catch (Exception e2) {
            collector.failed();
            throw SneakyThrow.sneakyThrow((Throwable)e2);
        }
    }

    private <T> T syncFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext invocationContext, MetricsCollector collector, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, ignored -> this.prepareSyncStrategy(operation, point, collector));
        InvocationContext ctx = new InvocationContext(() -> invocationContext.proceed());
        ctx.set(javax.interceptor.InvocationContext.class, (Object)invocationContext);
        return (T)strategy.apply(ctx);
    }

    private <T> Future<T> futureFlow(FaultToleranceOperation operation, javax.interceptor.InvocationContext invocationContext, MetricsCollector collector, InterceptionPoint point) throws Exception {
        FaultToleranceStrategy strategy = this.cache.getStrategy(point, ignored -> this.prepareFutureStrategy(operation, point, collector));
        InvocationContext ctx = new InvocationContext(() -> (Future)invocationContext.proceed());
        ctx.set(javax.interceptor.InvocationContext.class, (Object)invocationContext);
        return (Future)strategy.apply(ctx);
    }

    private <T> FaultToleranceStrategy<CompletionStage<T>> prepareAsyncStrategy(FaultToleranceOperation operation, InterceptionPoint point, MetricsCollector collector) {
        Object result = Invocation.invocation();
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            Integer size = (Integer)bulkheadConfig.get("value");
            Integer queueSize = (Integer)bulkheadConfig.get("waitingTaskQueue");
            result = new CompletionStageBulkhead((FaultToleranceStrategy)result, "CompletionStage[" + point.name() + "]", this.executorProvider.createAdHocExecutor(size), size.intValue(), queueSize.intValue(), (BulkheadBase.MetricsRecorder)collector);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            result = new CompletionStageTimeout((FaultToleranceStrategy)result, "Timeout[" + point.name() + "]", timeoutMs, (TimeoutWatcher)new ScheduledExecutorTimeoutWatcher(this.timeoutExecutor), this.asyncExecutor, (Timeout.MetricsRecorder)collector);
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CompletionStageCircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point.name() + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch(), (CircuitBreaker.MetricsRecorder)collector);
            result = new CircuitBreakerStateObserver(result, point, this.cbStateEvent);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new CompletionStageRetry((FaultToleranceStrategy)result, "Retry[" + point.name() + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, (Delay)new ThreadSleepDelay(delayMs, jitter), (Stopwatch)new SystemStopwatch(), (Retry.MetricsRecorder)collector);
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new CompletionStageFallback((FaultToleranceStrategy)result, "Fallback[" + point.name() + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"), (Fallback.MetricsRecorder)collector);
        }
        return result;
    }

    private <T> FaultToleranceStrategy<T> prepareSyncStrategy(FaultToleranceOperation operation, InterceptionPoint point, MetricsCollector collector) {
        Object result = Invocation.invocation();
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            result = new SemaphoreBulkhead((FaultToleranceStrategy)result, "Bulkhead[" + point.name() + "]", ((Integer)bulkheadConfig.get("value")).intValue(), (BulkheadBase.MetricsRecorder)collector);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            result = new Timeout((FaultToleranceStrategy)result, "Timeout[" + point.name() + "]", timeoutMs, (TimeoutWatcher)new ScheduledExecutorTimeoutWatcher(this.timeoutExecutor), (Timeout.MetricsRecorder)collector);
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point.name() + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch(), (CircuitBreaker.MetricsRecorder)collector);
            result = new CircuitBreakerStateObserver(result, point, this.cbStateEvent);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new Retry((FaultToleranceStrategy)result, "Retry[" + point.name() + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, (Delay)new ThreadSleepDelay(delayMs, jitter), (Stopwatch)new SystemStopwatch(), (Retry.MetricsRecorder)collector);
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new Fallback((FaultToleranceStrategy)result, "Fallback[" + point.name() + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"), (Fallback.MetricsRecorder)collector);
        }
        result = new GeneralMetricsRecorder((FaultToleranceStrategy)result, (GeneralMetrics)collector);
        return result;
    }

    private <T> FaultToleranceStrategy<Future<T>> prepareFutureStrategy(FaultToleranceOperation operation, InterceptionPoint point, MetricsCollector collector) {
        Object result = Invocation.invocation();
        result = new RequestScopeActivator(result, this.requestContextController);
        if (operation.hasBulkhead()) {
            BulkheadConfig bulkheadConfig = operation.getBulkhead();
            int size = (Integer)bulkheadConfig.get("value");
            int queueSize = (Integer)bulkheadConfig.get("waitingTaskQueue");
            ExecutorService executor = this.executorProvider.createAdHocExecutor(size);
            result = new ThreadPoolBulkhead((FaultToleranceStrategy)result, "Bulkhead[" + point.name() + "]", executor, size, queueSize, (BulkheadBase.MetricsRecorder)collector);
        }
        if (operation.hasTimeout()) {
            long timeoutMs = this.getTimeInMs(operation.getTimeout(), "value", "unit");
            result = new Timeout((FaultToleranceStrategy)result, "Timeout[" + point.name() + "]", timeoutMs, (TimeoutWatcher)new ScheduledExecutorTimeoutWatcher(this.timeoutExecutor), (Timeout.MetricsRecorder)collector);
            result = new AsyncTimeout((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        }
        if (operation.hasCircuitBreaker()) {
            CircuitBreakerConfig cbConfig = operation.getCircuitBreaker();
            long delayInMillis = this.getTimeInMs(cbConfig, "delay", "delayUnit");
            result = new CircuitBreaker((FaultToleranceStrategy)result, "CircuitBreaker[" + point.name() + "]", this.getSetOfThrowables(cbConfig, "failOn"), this.getSetOfThrowables(cbConfig, "skipOn"), delayInMillis, ((Integer)cbConfig.get("requestVolumeThreshold")).intValue(), ((Double)cbConfig.get("failureRatio")).doubleValue(), ((Integer)cbConfig.get("successThreshold")).intValue(), (Stopwatch)new SystemStopwatch(), (CircuitBreaker.MetricsRecorder)collector);
            result = new CircuitBreakerStateObserver(result, point, this.cbStateEvent);
        }
        if (operation.hasRetry()) {
            RetryConfig retryConf = operation.getRetry();
            long maxDurationMs = this.getTimeInMs(retryConf, "maxDuration", "durationUnit");
            long delayMs = this.getTimeInMs(retryConf, "delay", "delayUnit");
            long jitterMs = this.getTimeInMs(retryConf, "jitter", "jitterDelayUnit");
            Jitter jitter = jitterMs == 0L ? Jitter.ZERO : new RandomJitter(jitterMs);
            result = new Retry((FaultToleranceStrategy)result, "Retry[" + point.name() + "]", this.getSetOfThrowables(retryConf, "retryOn"), this.getSetOfThrowables(retryConf, "abortOn"), (long)((Integer)retryConf.get("maxRetries")).intValue(), maxDurationMs, (Delay)new ThreadSleepDelay(delayMs, jitter), (Stopwatch)new SystemStopwatch(), (Retry.MetricsRecorder)collector);
        }
        if (operation.hasFallback()) {
            FallbackConfig fallbackConf = operation.getFallback();
            result = new Fallback((FaultToleranceStrategy)result, "Fallback[" + point.name() + "]", this.prepareFallbackFunction(point, operation), this.getSetOfThrowables(fallbackConf, "applyOn"), this.getSetOfThrowables(fallbackConf, "skipOn"), (Fallback.MetricsRecorder)collector);
        }
        result = new GeneralMetricsRecorder((FaultToleranceStrategy)result, (GeneralMetrics)collector);
        result = new FutureExecution((FaultToleranceStrategy)result, (Executor)this.asyncExecutor);
        return result;
    }

    private <V> FallbackFunction<V> prepareFallbackFunction(InterceptionPoint point, FaultToleranceOperation operation) {
        Method fallbackMethod = null;
        FallbackConfig fallbackConfig = operation.getFallback();
        Class fallback = (Class)fallbackConfig.get("value");
        String fallbackMethodName = (String)fallbackConfig.get("fallbackMethod");
        if (fallback.equals(Fallback.DEFAULT.class) && !"".equals(fallbackMethodName)) {
            try {
                Method method = point.method();
                fallbackMethod = SecurityActions.getDeclaredMethod(point.beanClass(), method.getDeclaringClass(), fallbackMethodName, method.getGenericParameterTypes());
                if (fallbackMethod == null) {
                    throw new FaultToleranceException("Could not obtain fallback method " + fallbackMethodName);
                }
                SecurityActions.setAccessible(fallbackMethod);
            }
            catch (PrivilegedActionException e) {
                throw new FaultToleranceException("Could not obtain fallback method", (Throwable)e);
            }
        }
        Method fallbackMethodFinal = fallbackMethod;
        if (fallbackMethod != null) {
            boolean isDefault = fallbackMethodFinal.isDefault();
            return ctx -> {
                javax.interceptor.InvocationContext interceptionContext = (javax.interceptor.InvocationContext)ctx.invocationContext.get(javax.interceptor.InvocationContext.class);
                ExecutionContextWithInvocationContext executionContext = new ExecutionContextWithInvocationContext(interceptionContext);
                try {
                    if (isDefault) {
                        return DefaultMethodFallbackProvider.getFallback(fallbackMethodFinal, executionContext);
                    }
                    return fallbackMethodFinal.invoke(interceptionContext.getTarget(), interceptionContext.getParameters());
                }
                catch (Throwable e) {
                    if (e instanceof InvocationTargetException) {
                        e = e.getCause();
                    }
                    if (e instanceof Exception) {
                        throw (Exception)e;
                    }
                    throw new FaultToleranceException("Error during fallback method invocation", e);
                }
            };
        }
        FallbackHandler fallbackHandler = this.fallbackHandlerProvider.get(operation);
        if (fallbackHandler != null) {
            return ctx -> {
                javax.interceptor.InvocationContext interceptionContext = (javax.interceptor.InvocationContext)ctx.invocationContext.get(javax.interceptor.InvocationContext.class);
                ExecutionContextWithInvocationContext executionContext = new ExecutionContextWithInvocationContext(interceptionContext);
                executionContext.setFailure(ctx.failure);
                return fallbackHandler.handle((ExecutionContext)executionContext);
            };
        }
        throw new FaultToleranceException("Could not obtain fallback handler for " + point.name());
    }

    private long getTimeInMs(GenericConfig<?> config, String configKey, String unitConfigKey) {
        long time = (Long)config.get(configKey);
        ChronoUnit unit = (ChronoUnit)config.get(unitConfigKey);
        return Duration.of(time, unit).toMillis();
    }

    private SetOfThrowables getSetOfThrowables(GenericConfig<?> config, String configKey) {
        List<Class<? extends Throwable>> throwableClassList = this.toListOfThrowables(config, configKey);
        return SetOfThrowables.create(throwableClassList);
    }

    private List<Class<? extends Throwable>> toListOfThrowables(GenericConfig<?> config, String failOn) {
        Class[] throwableClasses = (Class[])config.get(failOn);
        return throwableClasses == null ? Collections.emptyList() : Arrays.asList(throwableClasses);
    }

    private MetricsCollector getMetricsCollector(FaultToleranceOperation operation, InterceptionPoint point) {
        return this.cache.getMetrics(point, ignored -> this.metricsCollectorFactory.createCollector(operation));
    }
}

