package io.smallrye.faulttolerance.config;

import io.smallrye.common.annotation.Blocking;
import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Override;
import java.lang.annotation.Annotation;

/**
 * Automatically generated from the {@link BlockingConfig} config interface, do not modify.
 */
public final class BlockingConfigImpl implements BlockingConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Blocking instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    private BlockingConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.blocking;
        this.onMethod = method.annotationsPresentDirectly.contains(Blocking.class);
    }

    public static BlockingConfigImpl create(FaultToleranceMethod method) {
        if (method.blocking == null) {
            return null;
        }
        if (!Config.isEnabled(Blocking.class, method.method)) {
            return null;
        }
        return new BlockingConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Blocking.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public void materialize() {
    }
}
