package io.smallrye.faulttolerance.config;

import io.smallrye.faulttolerance.autoconfig.Config;
import io.smallrye.faulttolerance.autoconfig.FaultToleranceMethod;
import io.smallrye.faulttolerance.autoconfig.MethodDescriptor;
import java.lang.Class;
import java.lang.Integer;
import java.lang.Long;
import java.lang.Override;
import java.lang.Throwable;
import java.lang.annotation.Annotation;
import java.time.temporal.ChronoUnit;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.faulttolerance.Retry;

/**
 * Automatically generated from the {@link RetryConfig} config interface, do not modify.
 */
public final class RetryConfigImpl implements RetryConfig {
    private final Class<?> beanClass;

    private final MethodDescriptor method;

    /**
     * Backing annotation instance. Used when runtime configuration doesn't override it.
     */
    private final Retry instance;

    /**
     * {@code true} if annotation was placed on a method; {@code false} if annotation was placed on a class.
     */
    private final boolean onMethod;

    /**
     * Cached value of the {@code Retry.maxRetries} annotation member; {@code null} if not looked up yet.
     */
    private Integer _maxRetries;

    /**
     * Cached value of the {@code Retry.delay} annotation member; {@code null} if not looked up yet.
     */
    private Long _delay;

    /**
     * Cached value of the {@code Retry.delayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _delayUnit;

    /**
     * Cached value of the {@code Retry.maxDuration} annotation member; {@code null} if not looked up yet.
     */
    private Long _maxDuration;

    /**
     * Cached value of the {@code Retry.durationUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _durationUnit;

    /**
     * Cached value of the {@code Retry.jitter} annotation member; {@code null} if not looked up yet.
     */
    private Long _jitter;

    /**
     * Cached value of the {@code Retry.jitterDelayUnit} annotation member; {@code null} if not looked up yet.
     */
    private ChronoUnit _jitterDelayUnit;

    /**
     * Cached value of the {@code Retry.retryOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _retryOn;

    /**
     * Cached value of the {@code Retry.abortOn} annotation member; {@code null} if not looked up yet.
     */
    private Class<? extends Throwable>[] _abortOn;

    private RetryConfigImpl(FaultToleranceMethod method) {
        this.beanClass = method.beanClass;
        this.method = method.method;
        this.instance = method.retry;
        this.onMethod = method.annotationsPresentDirectly.contains(Retry.class);
    }

    public static RetryConfigImpl create(FaultToleranceMethod method) {
        if (method.retry == null) {
            return null;
        }
        if (!Config.isEnabled(Retry.class, method.method)) {
            return null;
        }
        return new RetryConfigImpl(method);
    }

    @Override
    public Class<?> beanClass() {
        return beanClass;
    }

    @Override
    public MethodDescriptor method() {
        return method;
    }

    @Override
    public Class<? extends Annotation> annotationType() {
        return Retry.class;
    }

    @Override
    public boolean isOnMethod() {
        return onMethod;
    }

    @Override
    public int maxRetries() {
        if (_maxRetries == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/maxRetries";
                _maxRetries = config.getOptionalValue(key, int.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/maxRetries";
                _maxRetries = config.getOptionalValue(key, int.class).orElse(null);
            }
            if (_maxRetries == null) {
                // <annotation>/<parameter>
                _maxRetries = config.getOptionalValue("Retry/maxRetries", int.class).orElse(null);
            }
            if (_maxRetries == null) {
                // annotation value
                _maxRetries = instance.maxRetries();
            }
        }
        return _maxRetries;
    }

    @Override
    public long delay() {
        if (_delay == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/delay";
                _delay = config.getOptionalValue(key, long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/delay";
                _delay = config.getOptionalValue(key, long.class).orElse(null);
            }
            if (_delay == null) {
                // <annotation>/<parameter>
                _delay = config.getOptionalValue("Retry/delay", long.class).orElse(null);
            }
            if (_delay == null) {
                // annotation value
                _delay = instance.delay();
            }
        }
        return _delay;
    }

    @Override
    public ChronoUnit delayUnit() {
        if (_delayUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/delayUnit";
                _delayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/delayUnit";
                _delayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (_delayUnit == null) {
                // <annotation>/<parameter>
                _delayUnit = config.getOptionalValue("Retry/delayUnit", ChronoUnit.class).orElse(null);
            }
            if (_delayUnit == null) {
                // annotation value
                _delayUnit = instance.delayUnit();
            }
        }
        return _delayUnit;
    }

    @Override
    public long maxDuration() {
        if (_maxDuration == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/maxDuration";
                _maxDuration = config.getOptionalValue(key, long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/maxDuration";
                _maxDuration = config.getOptionalValue(key, long.class).orElse(null);
            }
            if (_maxDuration == null) {
                // <annotation>/<parameter>
                _maxDuration = config.getOptionalValue("Retry/maxDuration", long.class).orElse(null);
            }
            if (_maxDuration == null) {
                // annotation value
                _maxDuration = instance.maxDuration();
            }
        }
        return _maxDuration;
    }

    @Override
    public ChronoUnit durationUnit() {
        if (_durationUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/durationUnit";
                _durationUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/durationUnit";
                _durationUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (_durationUnit == null) {
                // <annotation>/<parameter>
                _durationUnit = config.getOptionalValue("Retry/durationUnit", ChronoUnit.class).orElse(null);
            }
            if (_durationUnit == null) {
                // annotation value
                _durationUnit = instance.durationUnit();
            }
        }
        return _durationUnit;
    }

    @Override
    public long jitter() {
        if (_jitter == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/jitter";
                _jitter = config.getOptionalValue(key, long.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/jitter";
                _jitter = config.getOptionalValue(key, long.class).orElse(null);
            }
            if (_jitter == null) {
                // <annotation>/<parameter>
                _jitter = config.getOptionalValue("Retry/jitter", long.class).orElse(null);
            }
            if (_jitter == null) {
                // annotation value
                _jitter = instance.jitter();
            }
        }
        return _jitter;
    }

    @Override
    public ChronoUnit jitterDelayUnit() {
        if (_jitterDelayUnit == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/jitterDelayUnit";
                _jitterDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/jitterDelayUnit";
                _jitterDelayUnit = config.getOptionalValue(key, ChronoUnit.class).orElse(null);
            }
            if (_jitterDelayUnit == null) {
                // <annotation>/<parameter>
                _jitterDelayUnit = config.getOptionalValue("Retry/jitterDelayUnit", ChronoUnit.class).orElse(null);
            }
            if (_jitterDelayUnit == null) {
                // annotation value
                _jitterDelayUnit = instance.jitterDelayUnit();
            }
        }
        return _jitterDelayUnit;
    }

    @Override
    public Class<? extends Throwable>[] retryOn() {
        if (_retryOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/retryOn";
                _retryOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/retryOn";
                _retryOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (_retryOn == null) {
                // <annotation>/<parameter>
                _retryOn = config.getOptionalValue("Retry/retryOn", Class[].class).orElse(null);
            }
            if (_retryOn == null) {
                // annotation value
                _retryOn = instance.retryOn();
            }
        }
        return _retryOn;
    }

    @Override
    public Class<? extends Throwable>[] abortOn() {
        if (_abortOn == null) {
            org.eclipse.microprofile.config.Config config = ConfigProvider.getConfig();
            if (onMethod) {
                // <classname>/<methodname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/" + method.name + "/Retry/abortOn";
                _abortOn = config.getOptionalValue(key, Class[].class).orElse(null);
            } else {
                // <classname>/<annotation>/<parameter>
                String key = method.declaringClass.getName() + "/Retry/abortOn";
                _abortOn = config.getOptionalValue(key, Class[].class).orElse(null);
            }
            if (_abortOn == null) {
                // <annotation>/<parameter>
                _abortOn = config.getOptionalValue("Retry/abortOn", Class[].class).orElse(null);
            }
            if (_abortOn == null) {
                // annotation value
                _abortOn = instance.abortOn();
            }
        }
        return _abortOn;
    }

    @Override
    public void materialize() {
        maxRetries();
        delay();
        delayUnit();
        maxDuration();
        durationUnit();
        jitter();
        jitterDelayUnit();
        retryOn();
        abortOn();
    }
}
