/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.tracing;

import graphql.ExecutionInput;
import graphql.GraphQLContext;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNamedType;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLType;
import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.smallrye.graphql.api.Context;
import io.smallrye.graphql.spi.EventingService;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletionException;
import javax.enterprise.inject.spi.CDI;

public class TracingService
implements EventingService {
    private final String SPAN_CLASS = "io.opentracing.Span";
    private final Map<String, Span> spans = Collections.synchronizedMap(new IdentityHashMap());
    private final Map<String, Scope> scopes = Collections.synchronizedMap(new IdentityHashMap());
    private Tracer tracer;
    private static final String UNDERSCORE = "_";
    private static final String EMPTY = "";
    private static final String PREFIX = "GraphQL";

    public void beforeExecute(Context context) {
        ExecutionInput executionInput = (ExecutionInput)context.unwrap(ExecutionInput.class);
        String operationName = TracingService.getOperationName(executionInput);
        Scope scope = this.getTracer().buildSpan(operationName).asChildOf(this.getTracer().activeSpan()).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getRequestedOperationTypes())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).startActive(true);
        this.scopes.put(context.getExecutionId(), scope);
        ((GraphQLContext)executionInput.getContext()).put((Object)"io.opentracing.Span", (Object)scope.span());
    }

    public void afterExecute(Context context) {
        Scope scope = this.scopes.remove(context.getExecutionId());
        if (scope != null) {
            scope.close();
        }
    }

    public void beforeDataFetch(Context context) {
        DataFetchingEnvironment env = (DataFetchingEnvironment)context.unwrap(DataFetchingEnvironment.class);
        Span parentSpan = this.getParentSpan(this.getTracer(), env);
        Scope scope = this.getTracer().buildSpan(this.getOperationName(env)).asChildOf(parentSpan).withTag("graphql.executionId", context.getExecutionId()).withTag("graphql.operationType", this.getOperationNameString(context.getOperationType())).withTag("graphql.operationName", context.getOperationName().orElse(EMPTY)).withTag("graphql.parent", context.getParentTypeName().orElse(EMPTY)).withTag("graphql.field", context.getFieldName()).withTag("graphql.path", context.getPath()).startActive(false);
        Span span = scope.span();
        GraphQLContext graphQLContext = (GraphQLContext)env.getContext();
        graphQLContext.put((Object)"io.opentracing.Span", (Object)span);
        this.spans.put(context.getExecutionId(), span);
    }

    public void errorDataFetch(String executionId, Throwable t) {
        Scope scope;
        Span span = this.spans.get(executionId);
        if (span == null && (scope = this.scopes.get(executionId)) != null && scope.span() != null) {
            span = scope.span();
        }
        if (span != null) {
            this.logError(span, t);
        }
    }

    public void errorExecute(String executionId, Throwable t) {
        Scope scope = this.scopes.remove(executionId);
        if (scope != null) {
            HashMap<String, Object> error = new HashMap<String, Object>();
            error.put("event.object", t);
            error.put("event", "error");
            scope.span().log(error);
            scope.close();
        }
    }

    public void afterDataFetch(Context context) {
        Span span = this.spans.remove(context.getExecutionId());
        span.finish();
        this.getTracer().scopeManager().active().close();
    }

    public String getConfigKey() {
        return "smallrye.graphql.tracing.enabled";
    }

    private Tracer getTracer() {
        if (this.tracer == null) {
            this.tracer = (Tracer)CDI.current().select(Tracer.class, new Annotation[0]).get();
        }
        return this.tracer;
    }

    private Span getParentSpan(Tracer tracer, DataFetchingEnvironment env) {
        GraphQLContext localContext = (GraphQLContext)env.getLocalContext();
        if (localContext != null && localContext.hasKey(Span.class)) {
            return (Span)localContext.get(Span.class);
        }
        GraphQLContext rootContext = (GraphQLContext)env.getContext();
        if (rootContext != null && rootContext.hasKey(Span.class)) {
            return (Span)rootContext.get(Span.class);
        }
        return tracer.activeSpan();
    }

    private void logError(Span span, Throwable throwable) {
        if (throwable instanceof InvocationTargetException || throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        HashMap<String, String> error = new HashMap<String, String>();
        if (throwable != null) {
            error.put("error.object", throwable.getMessage());
        }
        error.put("event", "error");
        span.log(error);
        span.setTag("error", true);
    }

    private String getOperationName(DataFetchingEnvironment env) {
        String parent = this.getName(env.getParentType());
        String name = "GraphQL:" + parent + "." + env.getField().getName();
        return name;
    }

    private static String getOperationName(ExecutionInput executionInput) {
        if (executionInput.getOperationName() != null && !executionInput.getOperationName().isEmpty()) {
            return "GraphQL:" + executionInput.getOperationName();
        }
        return PREFIX;
    }

    private String getName(GraphQLType graphQLType) {
        if (graphQLType instanceof GraphQLNamedType) {
            return ((GraphQLNamedType)graphQLType).getName();
        }
        if (graphQLType instanceof GraphQLNonNull) {
            return this.getName(((GraphQLNonNull)graphQLType).getWrappedType());
        }
        if (graphQLType instanceof GraphQLList) {
            return this.getName(((GraphQLList)graphQLType).getWrappedType());
        }
        return EMPTY;
    }

    private String getOperationNameString(List<String> types) {
        return String.join((CharSequence)UNDERSCORE, types);
    }

    private String getOperationNameString(String ... types) {
        return this.getOperationNameString(Arrays.asList(types));
    }
}

