/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.cdi.producer;

import graphql.schema.GraphQLSchema;
import io.smallrye.graphql.bootstrap.Bootstrap;
import io.smallrye.graphql.execution.ExecutionService;
import io.smallrye.graphql.schema.model.Schema;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.inject.Produces;

@ApplicationScoped
public class GraphQLProducer {
    @Produces
    ExecutionService executionService;
    @Produces
    GraphQLSchema graphQLSchema;
    @Produces
    Schema schema;

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public GraphQLSchema initialize(Schema schema) {
        return this.initialize(schema, false);
    }

    public GraphQLSchema initialize(Schema schema, boolean allowMultipleDeployments) {
        this.schema = schema;
        return this.initialize(allowMultipleDeployments);
    }

    public GraphQLSchema initialize(boolean allowMultipleDeployments) {
        this.graphQLSchema = Bootstrap.bootstrap((Schema)this.schema, (boolean)allowMultipleDeployments);
        this.executionService = new ExecutionService(this.graphQLSchema, this.schema.getBatchOperations(), this.schema.hasSubscriptions());
        return this.graphQLSchema;
    }

    public GraphQLSchema initialize() {
        return this.initialize(false);
    }
}

