/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.api;

import java.util.Objects;

public class SourceLocation {
    private final int line;
    private final int column;
    private final String sourceName;

    public SourceLocation() {
        this(0, 0, null);
    }

    public SourceLocation(int line, int column, String sourceName) {
        this.line = line;
        this.column = column;
        this.sourceName = sourceName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SourceLocation that = (SourceLocation)o;
        return this.line == that.line && this.column == that.column && Objects.equals(this.sourceName, that.sourceName);
    }

    public int hashCode() {
        return Objects.hash(this.line, this.column, this.sourceName);
    }

    public String toString() {
        return "(" + this.line + ":" + this.column + (this.sourceName == null ? "" : "@" + this.sourceName) + ")";
    }

    public int getLine() {
        return this.line;
    }

    public int getColumn() {
        return this.column;
    }

    public String getSourceName() {
        return this.sourceName;
    }
}

