/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.vertx.websocket;

import io.smallrye.graphql.client.vertx.websocket.WebSocketSubprotocolHandler;
import io.smallrye.mutiny.subscription.MultiEmitter;
import io.vertx.core.http.WebSocket;
import java.util.concurrent.atomic.AtomicReference;
import javax.json.JsonObject;
import org.jboss.logging.Logger;

public class BasicSmallRyeGraphQLWebSocketSubprotocolHandler
implements WebSocketSubprotocolHandler {
    private static final Logger log = Logger.getLogger(BasicSmallRyeGraphQLWebSocketSubprotocolHandler.class);
    private AtomicReference<WebSocket> webSocketReference = new AtomicReference();

    @Override
    public void handleWebSocketStart(JsonObject request, MultiEmitter<? super String> dataEmitter, WebSocket webSocket) {
        this.webSocketReference.set(webSocket);
        webSocket.writeTextMessage(request.toString());
        webSocket.handler(message -> {
            if (!dataEmitter.isCancelled()) {
                dataEmitter.emit((Object)message.toString());
            } else {
                log.warn((Object)"Received an additional item for a subscription that has already ended with a failure, dropping it.");
            }
        });
        webSocket.closeHandler(v -> dataEmitter.complete());
        dataEmitter.onTermination(() -> ((WebSocket)webSocket).close());
    }

    @Override
    public void handleCancel() {
        WebSocket webSocket = this.webSocketReference.get();
        if (webSocket != null) {
            webSocket.close((short)1000);
            log.debug((Object)"Closed the Websocket");
        }
    }
}

