package io.smallrye.graphql.client;

import java.util.Locale;
import java.io.Serializable;
import io.smallrye.graphql.client.dynamic.api.DynamicClientException;
import java.lang.String;
import java.util.Arrays;
import java.util.NoSuchElementException;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLClientMessages_$bundle implements SmallRyeGraphQLClientMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SmallRyeGraphQLClientMessages_$bundle() {}
    public static final SmallRyeGraphQLClientMessages_$bundle INSTANCE = new SmallRyeGraphQLClientMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cannotParseResponse$str() {
        return "SRGQLDC035000: Cannot parse response: %s";
    }
    @Override
    public final DynamicClientException cannotParseResponse(final String response) {
        final DynamicClientException result = new DynamicClientException(String.format(getLoggingLocale(), cannotParseResponse$str(), response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String urlNotConfiguredForNamedClient$str() {
        return "SRGQLDC035001: URL not configured for client. Please define the property %s/mp-graphql/url or pass it to your client builder dynamically";
    }
    @Override
    public final NoSuchElementException urlNotConfiguredForNamedClient(final String name) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), urlNotConfiguredForNamedClient$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String urlNotConfiguredForProgrammaticClient$str() {
        return "SRGQLDC035002: URL not configured for client. Please pass a url using your client builder.";
    }
    @Override
    public final NoSuchElementException urlNotConfiguredForProgrammaticClient() {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), urlNotConfiguredForProgrammaticClient$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
