package io.smallrye.graphql.client.dynamic;

import java.util.Locale;
import java.io.Serializable;
import io.smallrye.graphql.client.dynamic.api.DynamicClientException;
import java.lang.String;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLDynamicClientMessages_$bundle implements SmallRyeGraphQLDynamicClientMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SmallRyeGraphQLDynamicClientMessages_$bundle() {}
    public static final SmallRyeGraphQLDynamicClientMessages_$bundle INSTANCE = new SmallRyeGraphQLDynamicClientMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cannotParseResponse$str() {
        return "SRGQLDC035000: Cannot parse response: %s";
    }
    @Override
    public final DynamicClientException cannotParseResponse(final String response) {
        final DynamicClientException result = new DynamicClientException(String.format(getLoggingLocale(), cannotParseResponse$str(), response));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
}
