/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl;

import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientError;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientException;
import io.smallrye.graphql.client.typesafe.api.SourceLocation;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonUtils;
import io.smallrye.graphql.client.typesafe.impl.reflection.MethodInvocation;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonException;
import javax.json.JsonObject;
import javax.json.JsonPatch;
import javax.json.JsonPointer;
import javax.json.JsonStructure;
import javax.json.JsonValue;
import javax.json.stream.JsonCollectors;

public class ResultBuilder {
    private final MethodInvocation method;
    private final JsonObject response;
    private JsonObject data;
    private static final JsonPatch ERROR_MARK = Json.createPatchBuilder().add("/__typename", ErrorOr.class.getSimpleName()).build();

    public ResultBuilder(MethodInvocation method, String responseString) {
        this.method = method;
        this.response = Json.createReader((Reader)new StringReader(responseString)).readObject();
    }

    public Object read() {
        this.data = this.readData();
        this.readErrors();
        if (this.data == null) {
            return null;
        }
        JsonObject value = this.method.isSingle() ? (JsonValue)this.data.get((Object)this.method.getName()) : this.data;
        return JsonReader.readJson(this.method.toString(), this.method.getReturnType(), (JsonValue)value, null);
    }

    private JsonObject readData() {
        if (!this.response.containsKey((Object)"data") || this.response.isNull("data")) {
            return null;
        }
        JsonObject data = this.response.getJsonObject("data");
        if (this.method.isSingle() && !data.containsKey((Object)this.method.getName())) {
            throw new GraphQLClientException("no data for '" + this.method.getName() + "':\n  " + data);
        }
        return data;
    }

    private void readErrors() {
        if (!this.response.containsKey((Object)"errors") || this.response.isNull("errors")) {
            return;
        }
        JsonArray jsonErrors = this.response.getJsonArray("errors");
        if (jsonErrors == null) {
            return;
        }
        JsonArray unapplied = (JsonArray)jsonErrors.stream().filter(error -> !this.apply((JsonValue)error)).collect(JsonCollectors.toJsonArray());
        if (unapplied.isEmpty()) {
            return;
        }
        throw new GraphQLClientException("errors from service", unapplied.stream().map(this::convert).collect(Collectors.toList()));
    }

    private boolean apply(JsonValue error) {
        List<Object> path = ResultBuilder.getPath(error);
        if (this.data == null || path == null) {
            return false;
        }
        JsonPointer pointer = Json.createPointer((String)path.stream().map(Object::toString).collect(Collectors.joining("/", "/", "")));
        if (!this.exists(pointer)) {
            return false;
        }
        JsonArrayBuilder errors = Json.createArrayBuilder();
        if (pointer.containsValue((JsonStructure)this.data) && JsonUtils.isListOf(pointer.getValue((JsonStructure)this.data), ErrorOr.class.getSimpleName())) {
            pointer.getValue((JsonStructure)this.data).asJsonArray().forEach(arg_0 -> ((JsonArrayBuilder)errors).add(arg_0));
        }
        errors.add((JsonValue)ERROR_MARK.apply((JsonStructure)((JsonObject)error)));
        this.data = (JsonObject)pointer.replace((JsonStructure)this.data, (JsonValue)errors.build());
        return true;
    }

    private boolean exists(JsonPointer pointer) {
        try {
            pointer.containsValue((JsonStructure)this.data);
            return true;
        }
        catch (JsonException e) {
            return false;
        }
    }

    private GraphQLClientError convert(JsonValue jsonValue) {
        final JsonObject jsonObject = jsonValue.asJsonObject();
        return new GraphQLClientError(){

            public String getMessage() {
                return jsonObject.getString("message", null);
            }

            public List<SourceLocation> getLocations() {
                JsonArray locations = jsonObject.getJsonArray("locations");
                return locations == null ? null : locations.stream().map(this::toSourceLocation).collect(Collectors.toList());
            }

            private SourceLocation toSourceLocation(JsonValue jsonValue) {
                JsonObject jsonObject2 = jsonValue.asJsonObject();
                return new SourceLocation(jsonObject2.getInt("line", 0), jsonObject2.getInt("column", 0), jsonObject2.getString("sourceName", null));
            }

            public List<Object> getPath() {
                return ResultBuilder.getPath((JsonValue)jsonObject);
            }

            public Map<String, Object> getExtensions() {
                return JsonUtils.toMap(jsonObject.getJsonObject("extensions"));
            }

            public String toString() {
                return this.defaultToString();
            }
        };
    }

    private static List<Object> getPath(JsonValue jsonValue) {
        JsonArray jsonArray = jsonValue.asJsonObject().getJsonArray("path");
        return jsonArray == null ? null : jsonArray.stream().map(JsonUtils::toValue).collect(Collectors.toList());
    }
}

