package io.smallrye.graphql.client;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.lang.RuntimeException;
import java.util.Set;
import java.lang.Throwable;
import java.lang.String;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.lang.IllegalArgumentException;

/**
 * Warning this class consists of generated code.
 */
public class SmallRyeGraphQLClientMessages_$bundle implements SmallRyeGraphQLClientMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected SmallRyeGraphQLClientMessages_$bundle() {}
    public static final SmallRyeGraphQLClientMessages_$bundle INSTANCE = new SmallRyeGraphQLClientMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String cannotParseResponse$str() {
        return "SRGQLDC035000: Cannot parse response: %s";
    }
    @Override
    public final RuntimeException cannotParseResponse(final String response, final Throwable cause) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotParseResponse$str(), response), cause);
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String urlNotConfiguredForNamedClient$str() {
        return "SRGQLDC035001: URL not configured for client. Please define the property %s/mp-graphql/url or pass it to your client builder dynamically";
    }
    @Override
    public final NoSuchElementException urlNotConfiguredForNamedClient(final String name) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), urlNotConfiguredForNamedClient$str(), name));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String urlNotConfiguredForProgrammaticClient$str() {
        return "SRGQLDC035002: URL not configured for client. Please pass a url using your client builder.";
    }
    @Override
    public final NoSuchElementException urlNotConfiguredForProgrammaticClient() {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), urlNotConfiguredForProgrammaticClient$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String noDataInResponse$str() {
        return "SRGQLDC035003: Response did not contain any data";
    }
    @Override
    public final NoSuchElementException noDataInResponse() {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), noDataInResponse$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fieldNotFoundInResponse$str() {
        return "SRGQLDC035004: Field %s not found in response's data. Available fields are: %s";
    }
    @Override
    public final NoSuchElementException fieldNotFoundInResponse(final String field, final Set<String> availableFields) {
        final NoSuchElementException result = new NoSuchElementException(String.format(getLoggingLocale(), fieldNotFoundInResponse$str(), field, availableFields));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String unexpectedValueInResponse$str() {
        return "SRGQLDC035005: Value in the response at path '%s' is of an unexpected type: %s";
    }
    @Override
    public final RuntimeException unexpectedValueInResponse(final String path, final String value) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), unexpectedValueInResponse$str(), path, value));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseContainsSingleObject$str() {
        return "SRGQLDC035006: Field %s in the response is a single object, please use the method `getObject` instead of `getList`";
    }
    @Override
    public final IllegalArgumentException responseContainsSingleObject(final String field) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), responseContainsSingleObject$str(), field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String responseContainsArray$str() {
        return "SRGQLDC035007: Field %s in the response is an array, please use the method `getList` instead of `getObject`";
    }
    @Override
    public final IllegalArgumentException responseContainsArray(final String field) {
        final IllegalArgumentException result = new IllegalArgumentException(String.format(getLoggingLocale(), responseContainsArray$str(), field));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String fieldRecursionFound$str() {
        return "SRGQLDC035008: Field recursion found";
    }
    @Override
    public final IllegalStateException fieldRecursionFound() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), fieldRecursionFound$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String cannotInstantiateDomainObject$str() {
        return "SRGQLDC035010: Cannot instantiate %s";
    }
    @Override
    public final RuntimeException cannotInstantiateDomainObject(final String object, final Throwable t) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), cannotInstantiateDomainObject$str(), object), t);
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String missingDataForOperation$str() {
        return "SRGQLDC035011: The response does not contain any data for operation %s";
    }
    @Override
    public final RuntimeException missingDataForOperation(final String operation) {
        final RuntimeException result = new RuntimeException(String.format(getLoggingLocale(), missingDataForOperation$str(), operation));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
