/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.typesafe.impl.CollectionUtils;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.typesafe.impl.json.IndexedLocationBuilder;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonValue;

class JsonArrayReader
extends Reader<JsonArray> {
    private Class<?> collectionType;
    private TypeInfo itemType;

    JsonArrayReader(TypeInfo type, Location location, JsonArray value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        GraphQLClientValueHelper.check(this.location, this.value, this.type.isCollection());
        IndexedLocationBuilder locationBuilder = new IndexedLocationBuilder(this.location);
        return ((JsonArray)this.value).stream().map(item -> this.readItem(locationBuilder, (JsonValue)item)).collect(this.collector());
    }

    private Object readItem(IndexedLocationBuilder locationBuilder, JsonValue itemValue) {
        Location itemLocation = locationBuilder.nextLocation();
        TypeInfo itemType = this.getItemType();
        if (itemValue.getValueType() == JsonValue.ValueType.NULL && itemType.isNonNull()) {
            throw new InvalidResponseException("invalid null " + itemLocation);
        }
        return JsonReader.readJson(itemLocation, itemType, itemValue, this.field);
    }

    private Collector<Object, ?, ?> collector() {
        Class<?> collectionType = this.getCollectionType();
        if (collectionType.isArray()) {
            Class<?> rawItemType = this.getItemType().getRawType();
            return CollectionUtils.toArray(rawItemType);
        }
        if (Set.class.isAssignableFrom(collectionType)) {
            return Collectors.toSet();
        }
        assert (List.class.isAssignableFrom(collectionType) || collectionType.equals(Collection.class)) : "collection type " + collectionType.getName() + " not supported";
        return Collectors.toList();
    }

    private Class<?> getCollectionType() {
        if (this.collectionType == null) {
            this.collectionType = this.type.getRawType();
        }
        return this.collectionType;
    }

    private TypeInfo getItemType() {
        if (this.itemType == null) {
            this.itemType = this.type.getItemType();
        }
        return this.itemType;
    }
}

