/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.SmallRyeGraphQLClientMessages;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.typesafe.impl.json.JsonReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonUtils;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.Map;
import javax.json.JsonObject;
import javax.json.JsonValue;

class JsonObjectReader
extends Reader<JsonObject> {
    JsonObjectReader(TypeInfo type, Location location, JsonObject value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        GraphQLClientValueHelper.check(this.location, this.value, !this.type.isCollection() && !this.type.isScalar());
        if (Map.class.equals(this.type.getRawType())) {
            return JsonUtils.toMap((JsonObject)this.value);
        }
        return this.readObject();
    }

    private Object readObject() {
        if (!this.type.isRecord()) {
            Object instance = this.newInstance();
            this.type.fields().forEach(field -> {
                Object fieldValue = this.buildValue(this.location, (JsonObject)this.value, (FieldInfo)field);
                field.set(instance, fieldValue);
            });
            return instance;
        }
        Object[] values = this.type.fields().map(field -> this.buildValue(this.location, (JsonObject)this.value, (FieldInfo)field)).toArray(Object[]::new);
        return this.newInstance(values);
    }

    private Object newInstance(Object[] parameters) {
        try {
            return this.type.newInstance(parameters);
        }
        catch (Exception e) {
            throw SmallRyeGraphQLClientMessages.msg.cannotInstantiateDomainObject(this.location.toString(), e);
        }
    }

    private Object newInstance() {
        return this.newInstance(new Object[0]);
    }

    private Object buildValue(Location location, JsonObject value, FieldInfo field) {
        String fieldName = field.getAlias().orElseGet(field::getName);
        Location fieldLocation = new Location(field.getType(), location.getDescription() + "." + fieldName);
        JsonValue jsonFieldValue = (JsonValue)value.get((Object)fieldName);
        if (jsonFieldValue == null) {
            if (field.isNonNull()) {
                throw new InvalidResponseException("missing " + fieldLocation);
            }
            return null;
        }
        return JsonReader.readJson(fieldLocation, field.getType(), jsonFieldValue, field);
    }
}

