/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.json;

import io.smallrye.graphql.client.typesafe.api.ErrorOr;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientError;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientException;
import io.smallrye.graphql.client.typesafe.impl.json.GraphQLClientErrorImpl;
import io.smallrye.graphql.client.typesafe.impl.json.JsonArrayReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonBooleanReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNullReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonNumberReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonObjectReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonStringReader;
import io.smallrye.graphql.client.typesafe.impl.json.JsonUtils;
import io.smallrye.graphql.client.typesafe.impl.json.Location;
import io.smallrye.graphql.client.typesafe.impl.json.Reader;
import io.smallrye.graphql.client.typesafe.impl.reflection.FieldInfo;
import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.json.JsonArray;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonString;
import javax.json.JsonValue;

public class JsonReader
extends Reader<JsonValue> {
    public static Object readJson(String description, TypeInfo type, JsonValue value, FieldInfo field) {
        return JsonReader.readJson(new Location(type, description), type, value, field);
    }

    static Object readJson(Location location, TypeInfo type, JsonValue value, FieldInfo field) {
        return new JsonReader(type, location, value, field).read();
    }

    private JsonReader(TypeInfo type, Location location, JsonValue value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        if (this.type.isOptional()) {
            return Optional.ofNullable(JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field));
        }
        if (this.type.isErrorOr()) {
            return this.readErrorOr();
        }
        if (this.isListOfErrors(this.value) && !this.isGraphQlErrorsType()) {
            throw this.cantApplyErrors(this.readGraphQlClientErrors());
        }
        return this.reader(this.location).read();
    }

    private ErrorOr<Object> readErrorOr() {
        if (this.isListOfErrors(this.value)) {
            return ErrorOr.ofErrors(this.readGraphQlClientErrors());
        }
        return ErrorOr.of((Object)JsonReader.readJson(this.location, this.type.getItemType(), this.value, this.field));
    }

    private List<GraphQLClientError> readGraphQlClientErrors() {
        return this.value.asJsonArray().stream().map(item -> (GraphQLClientError)JsonReader.readJson(this.location, TypeInfo.of(GraphQLClientErrorImpl.class), item, this.field)).collect(Collectors.toList());
    }

    private boolean isListOfErrors(JsonValue jsonValue) {
        return JsonUtils.isListOf(jsonValue, ErrorOr.class.getSimpleName());
    }

    private boolean isGraphQlErrorsType() {
        return GraphQLClientError.class.isAssignableFrom(this.type.getRawType());
    }

    private GraphQLClientException cantApplyErrors(List<GraphQLClientError> errors) {
        return new GraphQLClientException("errors from service (and we can't apply them to a " + this.location + "; see ErrorOr)", errors);
    }

    private Reader<?> reader(Location location) {
        switch (this.value.getValueType()) {
            case ARRAY: {
                return new JsonArrayReader(this.type, location, (JsonArray)this.value, this.field);
            }
            case OBJECT: {
                return new JsonObjectReader(this.type, location, (JsonObject)this.value, this.field);
            }
            case STRING: {
                return new JsonStringReader(this.type, location, (JsonString)this.value, this.field);
            }
            case NUMBER: {
                return new JsonNumberReader(this.type, location, (JsonNumber)this.value, this.field);
            }
            case TRUE: 
            case FALSE: {
                return new JsonBooleanReader(this.type, location, this.value, this.field);
            }
            case NULL: {
                return new JsonNullReader(this.type, location, this.value, this.field);
            }
        }
        return null;
    }
}

