/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.typesafe.impl.reflection;

import io.smallrye.graphql.client.typesafe.impl.reflection.TypeInfo;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Optional;
import javax.json.bind.annotation.JsonbProperty;
import org.eclipse.microprofile.graphql.Name;
import org.eclipse.microprofile.graphql.NonNull;

public class FieldInfo {
    private final TypeInfo container;
    private final Field field;
    private final boolean includeIfNull;
    private final String name;
    private static final String JSONB_PROPERTY = "javax.json.bind.annotation.JsonbProperty";
    private static final String JACKSON_PROPERTY = "com.fasterxml.jackson.annotation.JsonProperty";

    FieldInfo(TypeInfo container, Field field) {
        this.container = container;
        this.field = field;
        JsonbProperty jsonbPropertyAnnotation = field.getAnnotation(JsonbProperty.class);
        this.includeIfNull = jsonbPropertyAnnotation != null ? jsonbPropertyAnnotation.nillable() : false;
        this.name = this.computeName();
    }

    public String toString() {
        return "field '" + this.getRawName() + "' in " + this.container;
    }

    public TypeInfo getType() {
        return new TypeInfo(this.container, this.field.getGenericType());
    }

    public String getName() {
        return this.name;
    }

    private String computeName() {
        String name = null;
        if (this.field.isAnnotationPresent(Name.class)) {
            name = this.field.getAnnotation(Name.class).value();
        } else {
            Object value;
            Optional<Annotation> jacksonProperty;
            Object value2;
            Optional<Annotation> jsonbProperty = this.getAnnotationByClassName(JSONB_PROPERTY);
            if (jsonbProperty.isPresent() && (value2 = this.getAnnotationParameter(jsonbProperty.get(), "value")) != null && !((String)value2).isEmpty()) {
                name = (String)value2;
            }
            if ((jacksonProperty = this.getAnnotationByClassName(JACKSON_PROPERTY)).isPresent() && (value = this.getAnnotationParameter(jacksonProperty.get(), "value")) != null && !((String)value).isEmpty()) {
                name = (String)value;
            }
        }
        if (name == null) {
            name = this.getRawName();
        }
        return name;
    }

    private Object getAnnotationParameter(Annotation annotation, String parameterName) {
        try {
            Method m = annotation.getClass().getMethod(parameterName, new Class[0]);
            return m.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private Optional<Annotation> getAnnotationByClassName(String className) {
        return Arrays.stream(this.field.getAnnotations()).filter(a -> a.annotationType().getName().equals(className)).findAny();
    }

    public String getRawName() {
        return this.field.getName();
    }

    public Optional<String> getAlias() {
        if (this.field.isAnnotationPresent(Name.class)) {
            return Optional.of(this.getRawName());
        }
        return Optional.empty();
    }

    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        return this.field.getAnnotation(annotationClass);
    }

    public Object get(Object instance) {
        try {
            this.field.setAccessible(true);
            return this.field.get(instance);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't get field " + this, e);
        }
    }

    public void set(Object instance, Object value) {
        try {
            this.field.setAccessible(true);
            this.field.set(instance, value);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("can't set field " + this + " to " + value, e);
        }
    }

    public boolean isNonNull() {
        return this.field.isAnnotationPresent(NonNull.class) || this.getType().isPrimitive();
    }

    public boolean isIncludeNull() {
        return this.includeIfNull;
    }
}

