/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe;

import io.smallrye.graphql.client.GraphQLClientException;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodInvocation;
import io.smallrye.graphql.client.impl.typesafe.reflection.MethodResolver;
import io.smallrye.graphql.client.impl.typesafe.reflection.ParameterInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import io.smallrye.graphql.client.typesafe.api.AuthorizationHeader;
import io.smallrye.graphql.client.typesafe.api.GraphQLClientApi;
import io.smallrye.graphql.client.typesafe.api.Header;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;

public class HeaderBuilder {
    private static final String APPLICATION_JSON_UTF8 = "application/json;charset=utf-8";
    private final Class<?> api;
    private final MethodInvocation method;
    private final Map<String, String> additionalHeaders;
    private final String configKey;
    private final Config config = ConfigProvider.getConfig();

    public HeaderBuilder(Class<?> api, MethodInvocation method, Map<String, String> additionalHeaders) {
        this.api = api;
        this.method = method;
        this.additionalHeaders = additionalHeaders;
        this.configKey = this.configKey();
    }

    private String configKey() {
        GraphQLClientApi annotation = this.api.getAnnotation(GraphQLClientApi.class);
        if (annotation == null || annotation.configKey().isEmpty()) {
            return this.api.getName();
        }
        return annotation.configKey();
    }

    public Map<String, String> build() {
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        this.addDefaultHeaders(headers);
        if (this.method != null) {
            this.method.getResolvedAnnotations(this.api, Header.class).forEach(annotation -> this.resolve((Header)annotation).apply(headers));
            this.method.headerParameters().forEach(parameter -> this.resolve((ParameterInfo)parameter).apply(headers));
            this.method.getResolvedAnnotations(this.api, AuthorizationHeader.class).reduce((first, second) -> second).map(this::resolveAuthHeader).ifPresent(auth -> headers.put("Authorization", (String)auth));
        }
        if (this.additionalHeaders != null) {
            headers.putAll(this.additionalHeaders);
        }
        headers.putAll(this.configuredCredentials());
        return headers;
    }

    private void addDefaultHeaders(Map<String, String> headers) {
        headers.put("Accept", APPLICATION_JSON_UTF8);
        headers.put("Content-Type", APPLICATION_JSON_UTF8);
    }

    private HeaderDescriptor resolve(Header header) {
        if (!header.method().isEmpty()) {
            if (!header.constant().isEmpty()) {
                throw new RuntimeException("Header with 'method' AND 'constant' not allowed: " + header);
            }
            return this.resolveHeaderMethod(header);
        }
        if (header.constant().isEmpty()) {
            throw new RuntimeException("Header must have either 'method' XOR 'constant': " + header);
        }
        if (header.name().isEmpty()) {
            throw new RuntimeException("Missing header name for constant '" + header.constant() + "'");
        }
        return new HeaderDescriptor(header.constant(), header.name(), null);
    }

    private HeaderDescriptor resolveHeaderMethod(Header header) {
        TypeInfo declaringType = this.method.getDeclaringType();
        MethodInvocation method = new MethodResolver(declaringType, header.method()).resolve();
        if (!method.isStatic()) {
            throw new RuntimeException("referenced header method '" + header.method() + "' in " + declaringType.getTypeName() + " is not static");
        }
        String value = this.callMethod(method);
        return new HeaderDescriptor(value, header.name(), this.toHeaderName(method));
    }

    private String callMethod(MethodInvocation method) {
        try {
            Object result = method.invoke(null);
            return result == null ? null : result.toString();
        }
        catch (GraphQLClientException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("can't resolve header value from method " + method, e);
        }
    }

    private String toHeaderName(MethodInvocation method) {
        String name = method.getName();
        return method.isRenamed() ? name : HeaderBuilder.camelToKebab(name);
    }

    private HeaderDescriptor resolve(ParameterInfo parameter) {
        Header header = ((Header[])parameter.getAnnotations(Header.class))[0];
        return new HeaderDescriptor(parameter.getValue(), header.name(), this.toHeaderName(parameter));
    }

    private String toHeaderName(ParameterInfo parameter) {
        String name = parameter.getName();
        return parameter.isRenamed() ? name : HeaderBuilder.camelToKebab(name);
    }

    private static String camelToKebab(String input) {
        return String.join((CharSequence)"-", input.split("(?=\\p{javaUpperCase})"));
    }

    private String resolveAuthHeader(AuthorizationHeader header) {
        String prefix = this.prefix(header);
        switch (header.type()) {
            case BASIC: {
                return this.basic(prefix);
            }
            case BEARER: {
                return this.bearer(prefix);
            }
        }
        throw new UnsupportedOperationException("unreachable");
    }

    private String prefix(AuthorizationHeader header) {
        String key;
        String string = key = header.confPrefix().isEmpty() ? this.configKey : header.confPrefix();
        if (key.endsWith("*")) {
            return key.substring(0, key.length() - 1);
        }
        return key + "/mp-graphql/";
    }

    private String basic(String prefix) {
        String username = (String)this.config.getValue(prefix + "username", String.class);
        String password = (String)this.config.getValue(prefix + "password", String.class);
        return this.basic(username, password);
    }

    private String basic(String username, String password) {
        String token = username + ":" + password;
        return "Basic " + Base64.getEncoder().encodeToString(token.getBytes(StandardCharsets.UTF_8));
    }

    private String bearer(String prefix) {
        return "Bearer " + (String)this.config.getValue(prefix + "bearer", String.class);
    }

    private Map<String, String> configuredCredentials() {
        Optional username = this.config.getOptionalValue(this.configKey + "/mp-graphql/username", String.class);
        Optional password = this.config.getOptionalValue(this.configKey + "/mp-graphql/password", String.class);
        return username.isPresent() && password.isPresent() ? Collections.singletonMap("Authorization", this.basic((String)username.get(), (String)password.get())) : Collections.emptyMap();
    }

    private static class HeaderDescriptor {
        private final String name;
        private final String value;

        public HeaderDescriptor(Object value, String name, String fallbackName) {
            this.value = value == null ? null : value.toString();
            this.name = name.isEmpty() ? fallbackName : name;
        }

        public void apply(Map<String, String> headers) {
            if (this.value != null) {
                headers.put(this.name, this.value);
            }
        }
    }
}

