/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.client.impl.typesafe.json;

import io.smallrye.graphql.client.InvalidResponseException;
import io.smallrye.graphql.client.impl.typesafe.json.GraphQLClientValueHelper;
import io.smallrye.graphql.client.impl.typesafe.json.Location;
import io.smallrye.graphql.client.impl.typesafe.json.Reader;
import io.smallrye.graphql.client.impl.typesafe.reflection.ConstructionInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.FieldInfo;
import io.smallrye.graphql.client.impl.typesafe.reflection.TypeInfo;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import javax.json.JsonString;
import javax.json.bind.annotation.JsonbDateFormat;
import javax.json.bind.annotation.JsonbNumberFormat;
import org.eclipse.microprofile.graphql.DateFormat;
import org.eclipse.microprofile.graphql.NumberFormat;

class JsonStringReader
extends Reader<JsonString> {
    JsonStringReader(TypeInfo type, Location location, JsonString value, FieldInfo field) {
        super(type, location, value, field);
    }

    @Override
    Object read() {
        if (Character.TYPE.equals(this.type.getRawType()) || Character.class.equals(this.type.getRawType())) {
            if (((JsonString)this.value).getChars().length() != 1) {
                throw GraphQLClientValueHelper.fail(this.location, this.value);
            }
            return Character.valueOf(((JsonString)this.value).getChars().charAt(0));
        }
        if (String.class.equals(this.type.getRawType()) || Object.class.equals(this.type.getRawType())) {
            return ((JsonString)this.value).getString();
        }
        if (this.type.isEnum()) {
            return this.enumValue();
        }
        if (Date.class.equals(this.type.getRawType())) {
            return this.formattedDate(((JsonString)this.value).getString());
        }
        if (UUID.class.equals(this.type.getRawType())) {
            return UUID.fromString(((JsonString)this.value).getString());
        }
        if (Number.class.isAssignableFrom(this.type.getRawType()) && this.field != null && (this.field.getAnnotation(NumberFormat.class) != null || this.field.getAnnotation(JsonbNumberFormat.class) != null)) {
            return this.formattedNumber(((JsonString)this.value).getString());
        }
        ConstructionInfo constructor = this.type.scalarConstructor().orElseThrow(() -> GraphQLClientValueHelper.fail(this.location, this.value));
        try {
            return constructor.execute(((JsonString)this.value).getString());
        }
        catch (Exception e) {
            throw new RuntimeException("can't create scalar " + this.location, e);
        }
    }

    private Date formattedDate(String value) {
        if (this.field != null) {
            DateFormat dateFormat;
            String format = null;
            String locale = null;
            JsonbDateFormat jsonbDateFormat = this.field.getAnnotation(JsonbDateFormat.class);
            if (jsonbDateFormat != null) {
                format = jsonbDateFormat.value();
                locale = jsonbDateFormat.locale();
            }
            if ((dateFormat = this.field.getAnnotation(DateFormat.class)) != null) {
                format = dateFormat.value();
                locale = dateFormat.locale();
            }
            SimpleDateFormat df = format != null ? (!locale.isEmpty() ? new SimpleDateFormat(format, Locale.forLanguageTag(locale)) : new SimpleDateFormat(format)) : new SimpleDateFormat();
            try {
                return df.parse(value);
            }
            catch (ParseException e) {
                throw new RuntimeException("Cannot parse date", e);
            }
        }
        return Date.from(Instant.parse(value));
    }

    private Number formattedNumber(String input) {
        NumberFormat numberFormat;
        String locale = null;
        String format = null;
        JsonbNumberFormat jsonbNumberFormat = this.field.getAnnotation(JsonbNumberFormat.class);
        if (jsonbNumberFormat != null) {
            locale = jsonbNumberFormat.locale();
            format = jsonbNumberFormat.value();
        }
        if ((numberFormat = this.field.getAnnotation(NumberFormat.class)) != null) {
            locale = numberFormat.locale();
            format = numberFormat.value();
        }
        java.text.NumberFormat nf = format != null && !format.isEmpty() ? new DecimalFormat(format) : (locale != null && !locale.isEmpty() ? java.text.NumberFormat.getInstance(Locale.forLanguageTag(locale)) : new DecimalFormat());
        try {
            return nf.parse(input);
        }
        catch (ParseException e) {
            throw new InvalidResponseException("Can't parse number", (Throwable)e);
        }
    }

    private Enum<?> enumValue() {
        return Enum.valueOf(this.type.getRawType(), ((JsonString)this.value).getString());
    }
}

