/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.creator.ArrayCreator;
import io.smallrye.graphql.schema.creator.ReferenceCreator;
import io.smallrye.graphql.schema.helper.DefaultValueHelper;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.FormatHelper;
import io.smallrye.graphql.schema.helper.IgnoreHelper;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.NonNullHelper;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.Array;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.TransformInfo;
import java.util.Optional;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.Type;

public class ArgumentCreator {
    private ArgumentCreator() {
    }

    public static Optional<Argument> createArgument(Type argumentType, MethodInfo methodInfo, short position) {
        Annotations annotationsForThisArgument = Annotations.getAnnotationsForArgument(methodInfo, position);
        if (!IgnoreHelper.shouldIgnore(annotationsForThisArgument)) {
            if (methodInfo.parameters() != null && !methodInfo.parameters().isEmpty()) {
                argumentType = (Type)methodInfo.parameters().get(position);
            }
            String defaultName = methodInfo.parameterName((int)position);
            String name = annotationsForThisArgument.getOneOfTheseAnnotationsValue(Annotations.NAME).orElse(defaultName);
            Optional<String> maybeDescription = DescriptionHelper.getDescriptionForField(annotationsForThisArgument, argumentType);
            Reference reference = ReferenceCreator.createReferenceForOperationArgument(argumentType, annotationsForThisArgument);
            Argument argument = new Argument(defaultName, methodInfo.name(), MethodHelper.getPropertyName(Direction.IN, methodInfo.name()), name, (String)maybeDescription.orElse(null), reference);
            if (NonNullHelper.markAsNonNull(argumentType, annotationsForThisArgument)) {
                argument.setNotNull(true);
            }
            argument.setArray((Array)ArrayCreator.createArray(argumentType).orElse(null));
            argument.setTransformInfo((TransformInfo)FormatHelper.getFormat(argumentType, annotationsForThisArgument).orElse(null));
            argument.setDefaultValue((String)DefaultValueHelper.getDefaultValue(annotationsForThisArgument).orElse(null));
            return Optional.of(argument);
        }
        return Optional.empty();
    }
}

