/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.creator.type;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import io.smallrye.graphql.schema.creator.FieldCreator;
import io.smallrye.graphql.schema.creator.type.Creator;
import io.smallrye.graphql.schema.helper.DescriptionHelper;
import io.smallrye.graphql.schema.helper.Direction;
import io.smallrye.graphql.schema.helper.MethodHelper;
import io.smallrye.graphql.schema.helper.TypeNameHelper;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.ArrayList;
import java.util.HashMap;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.logging.Logger;

public class InputTypeCreator
implements Creator<InputType> {
    private static final Logger LOG = Logger.getLogger((String)InputTypeCreator.class.getName());
    private static final String JAVA_DOT = "java.";

    @Override
    public InputType create(ClassInfo classInfo) {
        LOG.debug((Object)("Creating Input from " + classInfo.name().toString()));
        Annotations annotations = Annotations.getAnnotationsForClass(classInfo);
        String name = TypeNameHelper.getAnyTypeName(ReferenceType.INPUT, classInfo, annotations);
        String description = DescriptionHelper.getDescriptionForType(annotations).orElse(null);
        InputType inputType = new InputType(classInfo.name().toString(), name, description);
        this.addFields(inputType, classInfo);
        return inputType;
    }

    private void addFields(InputType inputType, ClassInfo classInfo) {
        ArrayList allMethods = new ArrayList();
        HashMap<String, FieldInfo> allFields = new HashMap<String, FieldInfo>();
        ClassInfo c = classInfo;
        while (c != null) {
            if (!c.toString().startsWith(JAVA_DOT)) {
                allMethods.addAll(c.methods());
                if (c.fields() != null && !c.fields().isEmpty()) {
                    for (FieldInfo fieldInfo : c.fields()) {
                        allFields.putIfAbsent(fieldInfo.name(), fieldInfo);
                    }
                }
            }
            c = ScanningContext.getIndex().getClassByName(c.superName());
        }
        for (MethodInfo methodInfo : allMethods) {
            if (!MethodHelper.isPropertyMethod(Direction.IN, methodInfo.name())) continue;
            String fieldName = MethodHelper.getPropertyName(Direction.IN, methodInfo.name());
            FieldInfo fieldInfo = (FieldInfo)allFields.get(fieldName);
            FieldCreator.createFieldForPojo(Direction.IN, fieldInfo, methodInfo).ifPresent(arg_0 -> ((InputType)inputType).addField(arg_0));
        }
    }
}

