/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.helper;

import io.smallrye.graphql.schema.Annotations;
import io.smallrye.graphql.schema.ScanningContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.DotName;
import org.jboss.jandex.MethodParameterInfo;
import org.jboss.jandex.Type;
import org.jboss.logging.Logger;

public class SourceOperationHelper {
    private static final Logger LOG = Logger.getLogger((String)SourceOperationHelper.class.getName());

    private SourceOperationHelper() {
    }

    public static Map<DotName, List<MethodParameterInfo>> getAllSourceAnnotations() {
        HashMap<DotName, List<MethodParameterInfo>> sourceFields = new HashMap<DotName, List<MethodParameterInfo>>();
        Collection sourceAnnotations = ScanningContext.getIndex().getAnnotations(Annotations.SOURCE);
        for (AnnotationInstance ai : sourceAnnotations) {
            AnnotationTarget target = ai.target();
            if (target.kind().equals((Object)AnnotationTarget.Kind.METHOD_PARAMETER)) {
                MethodParameterInfo methodParameter = target.asMethodParameter();
                short position = methodParameter.position();
                DotName name = ((Type)methodParameter.method().parameters().get(position)).name();
                sourceFields.computeIfAbsent(name, k -> new ArrayList()).add(methodParameter);
                continue;
            }
            LOG.warn((Object)("Ignoring " + ai.target() + " on kind " + ai.target().kind() + ". Only expecting @" + Annotations.SOURCE.local() + " on Method parameters"));
        }
        return sourceFields;
    }
}

