/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.schema.model;

import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class InputType
extends Reference {
    private String description;
    private Map<String, Field> fields = new LinkedHashMap<String, Field>();
    private List<Field> creatorParameters = new ArrayList<Field>();

    public InputType() {
    }

    public InputType(String className, String name, String description) {
        super(className, name, ReferenceType.INPUT);
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Map<String, Field> getFields() {
        return this.fields;
    }

    public void setFields(Map<String, Field> fields) {
        this.fields = fields;
    }

    public void addField(Field field) {
        this.fields.put(field.getName(), field);
    }

    public boolean hasFields() {
        return !this.fields.isEmpty();
    }

    public boolean hasField(String fieldName) {
        return this.fields.containsKey(fieldName);
    }

    public List<Field> getCreatorParameters() {
        return this.creatorParameters;
    }

    public void setCreatorParameters(List<Field> creatorParameters) {
        this.creatorParameters = creatorParameters;
    }

    public void addCreatorParameter(Field creatorParameter) {
        this.creatorParameters.add(creatorParameter);
    }
}

