/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.transformation;

import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Transformation;
import io.smallrye.graphql.transformation.AbstractDataFetcherException;
import io.smallrye.graphql.transformation.CharTransformer;
import io.smallrye.graphql.transformation.DateTransformer;
import io.smallrye.graphql.transformation.DurationTransformer;
import io.smallrye.graphql.transformation.FormattedNumberTransformer;
import io.smallrye.graphql.transformation.LegacyDateTransformer;
import io.smallrye.graphql.transformation.NumberTransformer;
import io.smallrye.graphql.transformation.PassThroughTransformer;
import io.smallrye.graphql.transformation.PeriodTransformer;
import io.smallrye.graphql.transformation.TransformException;
import io.smallrye.graphql.transformation.UriTransformer;
import io.smallrye.graphql.transformation.UrlTransformer;
import io.smallrye.graphql.transformation.UuidTransformer;

public interface Transformer<IN, OUT> {
    public static final PassThroughTransformer PASS_THROUGH_TRANSFORMER = new PassThroughTransformer();
    public static final UuidTransformer UUID_TRANSFORMER = new UuidTransformer();
    public static final UrlTransformer URL_TRANSFORMER = new UrlTransformer();
    public static final UriTransformer URI_TRANSFORMER = new UriTransformer();
    public static final PeriodTransformer PERIOD_TRANSFORMER = new PeriodTransformer();
    public static final DurationTransformer DURATION_TRANSFORMER = new DurationTransformer();
    public static final CharTransformer CHAR_TRANSFORMER = new CharTransformer();

    public static Object out(Field field, Object object) throws AbstractDataFetcherException {
        if (!Transformer.shouldTransform(field)) {
            return object;
        }
        try {
            Transformer transformer = Transformer.transformer(field);
            return transformer.out(object);
        }
        catch (Exception e) {
            SmallRyeGraphQLServerLogging.log.transformError(e);
            throw new TransformException(e, field, object);
        }
    }

    public static Object in(Field field, Object object) throws AbstractDataFetcherException {
        if (!Transformer.shouldTransform(field)) {
            return object;
        }
        try {
            Transformer transformer = Transformer.transformer(field);
            return transformer.in(object);
        }
        catch (Exception e) {
            throw new TransformException(e, field, object);
        }
    }

    public static Transformer transformer(Field field) {
        if (field.hasTransformation()) {
            Transformation format = field.getTransformation();
            if (format.getType().equals((Object)Transformation.Type.NUMBER)) {
                return new FormattedNumberTransformer(field);
            }
            if (format.getType().equals((Object)Transformation.Type.DATE)) {
                return Transformer.dateTransformer(field);
            }
        } else {
            if (Classes.isDateLikeType(field.getReference().getClassName())) {
                return Transformer.dateTransformer(field);
            }
            if (Classes.isNumberLikeType(field.getReference().getClassName())) {
                return new NumberTransformer(field);
            }
            if (Classes.isCharacter(field.getReference().getClassName())) {
                return CHAR_TRANSFORMER;
            }
            if (Classes.isUUID(field.getReference().getClassName())) {
                return UUID_TRANSFORMER;
            }
            if (Classes.isURL(field.getReference().getClassName())) {
                return URL_TRANSFORMER;
            }
            if (Classes.isURI(field.getReference().getClassName())) {
                return URI_TRANSFORMER;
            }
            if (Classes.isDuration(field.getReference().getClassName())) {
                return DURATION_TRANSFORMER;
            }
            if (Classes.isPeriod(field.getReference().getClassName())) {
                return PERIOD_TRANSFORMER;
            }
        }
        return PASS_THROUGH_TRANSFORMER;
    }

    public static Transformer dateTransformer(Field field) {
        if (LegacyDateTransformer.SUPPORTED_TYPES.contains(field.getReference().getClassName())) {
            return new LegacyDateTransformer(field);
        }
        return new DateTransformer(field);
    }

    public static boolean shouldTransform(Field field) {
        return field.getReference().getType() == ReferenceType.SCALAR && !field.getReference().getClassName().equals(field.getReference().getGraphQlClassName());
    }

    public IN in(OUT var1) throws Exception;

    public OUT out(IN var1);
}

