package io.smallrye.jwt.util;

import java.util.Locale;
import java.io.Serializable;
import org.jboss.logging.DelegatingBasicLogger;
import org.jboss.logging.BasicLogger;
import java.lang.Throwable;
import java.lang.String;
import org.jboss.logging.Logger;


import static org.jboss.logging.Logger.Level.DEBUG;

/**
 * Warning this class consists of generated code.
 */
public class JWTUtilLogging_$logger extends DelegatingBasicLogger implements JWTUtilLogging, BasicLogger, Serializable {
    private static final long serialVersionUID = 1L;
    private static final String FQCN = JWTUtilLogging_$logger.class.getName();
    public JWTUtilLogging_$logger(final Logger log) {
        super(log);
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    @Override
    public final void creatingKeyFromPemKey() {
        super.log.logf(FQCN, DEBUG, null, creatingKeyFromPemKey$str());
    }
    protected String creatingKeyFromPemKey$str() {
        return "SRJWT01003: Trying to create a key from the encoded PEM key...";
    }
    @Override
    public final void creatingKeyFromPemKeyFailed(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, creatingKeyFromPemKeyFailed$str());
    }
    protected String creatingKeyFromPemKeyFailed$str() {
        return "SRJWT01004: Failed to create a key from the encoded PEM key";
    }
    @Override
    public final void creatingKeyFromPemCertificate() {
        super.log.logf(FQCN, DEBUG, null, creatingKeyFromPemCertificate$str());
    }
    protected String creatingKeyFromPemCertificate$str() {
        return "SRJWT01005: Trying to create a key from the encoded PEM certificate...";
    }
    @Override
    public final void creatingKeyFromPemCertificateFailed(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, creatingKeyFromPemCertificateFailed$str());
    }
    protected String creatingKeyFromPemCertificateFailed$str() {
        return "SRJWT01006: Failed to to create a key from the encoded PEM certificate";
    }
    @Override
    public final void loadingJwks() {
        super.log.logf(FQCN, DEBUG, null, loadingJwks$str());
    }
    protected String loadingJwks$str() {
        return "SRJWT01007: Trying to load the local JWK(S)...";
    }
    @Override
    public final void loadingJwksFailed(final Throwable throwable) {
        super.log.logf(FQCN, DEBUG, throwable, loadingJwksFailed$str());
    }
    protected String loadingJwksFailed$str() {
        return "SRJWT01008: Failed to load the JWK(S)";
    }
    @Override
    public final void parsingJwksFailed() {
        super.log.logf(FQCN, DEBUG, null, parsingJwksFailed$str());
    }
    protected String parsingJwksFailed$str() {
        return "SRJWT01009: Failed to parse the JWK JSON representation";
    }
    @Override
    public final void fileIsNotFound(final String fileLocation) {
        super.log.logf(FQCN, DEBUG, null, fileIsNotFound$str(), fileLocation);
    }
    protected String fileIsNotFound$str() {
        return "SRJWT01010: File %s is not found";
    }
}
