/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.AbstractBearerTokenExtractor;
import io.smallrye.jwt.auth.cdi.PrincipalProducer;
import io.smallrye.jwt.auth.jaxrs.JAXRSLogging;
import io.smallrye.jwt.auth.jaxrs.JWTSecurityContext;
import io.smallrye.jwt.auth.principal.JWTAuthContextInfo;
import io.smallrye.jwt.auth.principal.JWTParser;
import java.io.IOException;
import java.security.Principal;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.core.Cookie;
import javax.ws.rs.core.SecurityContext;
import org.eclipse.microprofile.jwt.JsonWebToken;

@PreMatching
@Priority(value=1000)
public class JWTAuthenticationFilter
implements ContainerRequestFilter {
    @Inject
    private JWTAuthContextInfo authContextInfo;
    @Inject
    private JWTParser jwtParser;
    @Inject
    private PrincipalProducer producer;

    public void filter(ContainerRequestContext requestContext) throws IOException {
        BearerTokenExtractor extractor;
        String bearerToken;
        SecurityContext securityContext = requestContext.getSecurityContext();
        Principal principal = securityContext.getUserPrincipal();
        if (!(principal instanceof JsonWebToken) && (bearerToken = (extractor = new BearerTokenExtractor(requestContext, this.authContextInfo)).getBearerToken()) != null) {
            try {
                JsonWebToken jwtPrincipal = this.jwtParser.parse(bearerToken);
                this.producer.setJsonWebToken(jwtPrincipal);
                JWTSecurityContext jwtSecurityContext = new JWTSecurityContext(securityContext, jwtPrincipal);
                requestContext.setSecurityContext((SecurityContext)jwtSecurityContext);
                JAXRSLogging.log.success();
            }
            catch (Exception e) {
                JAXRSLogging.log.unableParseJWT(e);
            }
        }
    }

    private static class BearerTokenExtractor
    extends AbstractBearerTokenExtractor {
        private final ContainerRequestContext requestContext;

        BearerTokenExtractor(ContainerRequestContext requestContext, JWTAuthContextInfo authContextInfo) {
            super(authContextInfo);
            this.requestContext = requestContext;
        }

        @Override
        protected String getHeaderValue(String headerName) {
            return this.requestContext.getHeaderString(headerName);
        }

        @Override
        protected String getCookieValue(String cookieName) {
            Cookie tokenCookie = (Cookie)this.requestContext.getCookies().get(cookieName);
            if (tokenCookie != null) {
                return tokenCookie.getValue();
            }
            return null;
        }
    }
}

