/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.jwt.auth.jaxrs;

import io.smallrye.jwt.auth.cdi.SmallRyeJWTAuthCDIExtension;
import io.smallrye.jwt.auth.jaxrs.JAXRSLogging;
import io.smallrye.jwt.auth.jaxrs.JWTAuthenticationFilter;
import io.smallrye.jwt.auth.jaxrs.JWTAuthorizationFilterRegistrar;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.eclipse.microprofile.auth.LoginConfig;

public class SmallRyeJWTAuthJaxRsFeature
implements Feature {
    @Context
    private Application restApplication;

    public boolean configure(FeatureContext context) {
        boolean enabled = this.mpJwtEnabled();
        if (enabled) {
            context.register(JWTAuthorizationFilterRegistrar.class);
            if (!SmallRyeJWTAuthCDIExtension.isHttpAuthMechanismEnabled()) {
                context.register(JWTAuthenticationFilter.class);
                JAXRSLogging.log.eeSecurityNotInUseButRegistered(JWTAuthenticationFilter.class.getSimpleName());
            }
            JAXRSLogging.log.mpJWTLoginConfigPresent(this.getClass().getSimpleName());
        } else {
            JAXRSLogging.log.mpJWTLoginConfigNotFound(this.getClass().getSimpleName());
        }
        return enabled;
    }

    boolean mpJwtEnabled() {
        Class<?> applicationClass;
        boolean enabled = false;
        if (this.restApplication != null && (applicationClass = this.restApplication.getClass()).isAnnotationPresent(LoginConfig.class)) {
            LoginConfig config = applicationClass.getAnnotation(LoginConfig.class);
            enabled = "MP-JWT".equals(config.authMethod());
        }
        return enabled;
    }
}

