package io.smallrye.openapi.api;

import java.util.Locale;
import java.lang.IllegalStateException;
import java.io.Serializable;
import java.util.Arrays;

/**
 * Warning this class consists of generated code.
 */
public class ApiMessages_$bundle implements ApiMessages, Serializable {
    private static final long serialVersionUID = 1L;
    protected ApiMessages_$bundle() {}
    public static final ApiMessages_$bundle INSTANCE = new ApiMessages_$bundle();
    protected Object readResolve() {
        return INSTANCE;
    }
    private static final Locale LOCALE = Locale.ROOT;
    protected Locale getLoggingLocale() {
        return LOCALE;
    }
    protected String modelNotInitialized$str() {
        return "Model not initialized yet";
    }
    @Override
    public final IllegalStateException modelNotInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), modelNotInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    private static void _copyStackTraceMinusOne(final Throwable e) {
        final StackTraceElement[] st = e.getStackTrace();
        e.setStackTrace(Arrays.copyOfRange(st, 1, st.length));
    }
    protected String modelAlreadyInitialized$str() {
        return "SROAP00001: Model already initialized";
    }
    @Override
    public final IllegalStateException modelAlreadyInitialized() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), modelAlreadyInitialized$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
    protected String configMustBeSet$str() {
        return "SROAP00002: OpenApiConfig must be set before init";
    }
    @Override
    public final IllegalStateException configMustBeSet() {
        final IllegalStateException result = new IllegalStateException(String.format(getLoggingLocale(), configMustBeSet$str()));
        _copyStackTraceMinusOne(result);
        return result;
    }
}
