/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.runtime.scanner.dataobject;

import io.smallrye.openapi.api.constants.JacksonConstants;
import io.smallrye.openapi.api.constants.JaxbConstants;
import io.smallrye.openapi.api.constants.JsonbConstants;
import io.smallrye.openapi.runtime.io.schema.SchemaConstant;
import io.smallrye.openapi.runtime.scanner.dataobject.AugmentedIndexView;
import io.smallrye.openapi.runtime.scanner.dataobject.BeanValidationScanner;
import io.smallrye.openapi.runtime.scanner.dataobject.DataObjectLogging;
import io.smallrye.openapi.runtime.scanner.dataobject.IgnoreResolver;
import io.smallrye.openapi.runtime.scanner.dataobject.PropertyNamingStrategyFactory;
import io.smallrye.openapi.runtime.scanner.spi.AnnotationScannerContext;
import io.smallrye.openapi.runtime.util.JandexUtil;
import io.smallrye.openapi.runtime.util.TypeUtil;
import java.lang.reflect.Modifier;
import java.util.AbstractMap;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.FieldInfo;
import org.jboss.jandex.MethodInfo;
import org.jboss.jandex.ParameterizedType;
import org.jboss.jandex.Type;
import org.jboss.jandex.TypeVariable;

public class TypeResolver {
    private static final Type BOOLEAN_TYPE = Type.create((DotName)DotName.createSimple((String)Boolean.class.getName()), (Type.Kind)Type.Kind.CLASS);
    static final String METHOD_PREFIX_GET = "get";
    static final String METHOD_PREFIX_IS = "is";
    static final String METHOD_PREFIX_SET = "set";
    private final UnaryOperator<String> nameTranslator;
    private final Deque<Map<String, Type>> resolutionStack;
    private final String propertyName;
    private FieldInfo field;
    private MethodInfo readMethod;
    private MethodInfo writeMethod;
    private boolean ignored = false;
    private boolean exposed = false;
    private boolean readOnly = false;
    private boolean writeOnly = false;
    private Type leaf;
    private final List<AnnotationTarget> constraintTargets = new ArrayList<AnnotationTarget>();
    private String propertyNamePrefix;
    private String propertyNameSuffix;
    private static final Comparator<AnnotationTarget> targetComparator = (t1, t2) -> {
        int result = TypeResolver.compareAnnotation(t1, t2, SchemaConstant.DOTNAME_SCHEMA);
        if (result != 0) {
            return result;
        }
        for (DotName jsonbProperty : JsonbConstants.JSONB_PROPERTY) {
            result = TypeResolver.compareAnnotation(t1, t2, jsonbProperty);
            if (result == 0) continue;
            return result;
        }
        result = TypeResolver.compareAnnotation(t1, t2, JacksonConstants.JSON_PROPERTY);
        if (result != 0) {
            return result;
        }
        for (DotName xmlElement : JaxbConstants.XML_ELEMENT) {
            result = TypeResolver.compareAnnotation(t1, t2, xmlElement);
            if (result == 0) continue;
            return result;
        }
        for (DotName xmlAttribute : JaxbConstants.XML_ATTRIBUTE) {
            result = TypeResolver.compareAnnotation(t1, t2, xmlAttribute);
            if (result == 0) continue;
            return result;
        }
        if (t1.kind() == AnnotationTarget.Kind.FIELD) {
            return -1;
        }
        if (t2.kind() == AnnotationTarget.Kind.FIELD) {
            return 1;
        }
        if (TypeResolver.isAccessor(t1.asMethod()) && !TypeResolver.isAccessor(t2.asMethod())) {
            return -1;
        }
        return 0;
    };
    private Queue<AnnotationTarget> targets = new PriorityQueue<AnnotationTarget>(targetComparator);

    private static int compareAnnotation(AnnotationTarget t1, AnnotationTarget t2, DotName annotationName) {
        boolean hasAnno1 = TypeUtil.hasAnnotation(t1, annotationName);
        boolean hasAnno2 = TypeUtil.hasAnnotation(t2, annotationName);
        if (hasAnno1) {
            if (!hasAnno2) {
                return -1;
            }
        } else if (hasAnno2) {
            return 1;
        }
        return 0;
    }

    private TypeResolver(UnaryOperator<String> nameTranslator, String propertyName, FieldInfo field, Deque<Map<String, Type>> resolutionStack) {
        this.nameTranslator = nameTranslator;
        this.propertyName = propertyName;
        this.field = field;
        this.resolutionStack = resolutionStack;
        if (field != null) {
            this.leaf = field.type();
            this.targets.add((AnnotationTarget)field);
        } else {
            this.leaf = null;
        }
    }

    public ClassInfo getDeclaringClass() {
        return TypeUtil.getDeclaringClass(this.getAnnotationTarget());
    }

    public AnnotationTarget getAnnotationTarget() {
        return this.targets.peek();
    }

    public Type getUnresolvedType() {
        return this.leaf;
    }

    public String getPropertyName() {
        AnnotationTarget target = this.getAnnotationTarget();
        String name = (String)TypeUtil.getAnnotationValue(target, SchemaConstant.DOTNAME_SCHEMA, "name");
        if (name != null) {
            return this.wrap(name);
        }
        name = (String)TypeUtil.getAnnotationValue(target, JsonbConstants.JSONB_PROPERTY, "value");
        if (name != null) {
            return this.wrap(name);
        }
        name = (String)TypeUtil.getAnnotationValue(target, JacksonConstants.JSON_PROPERTY, "value");
        if (name != null) {
            return this.wrap(name);
        }
        return (String)this.nameTranslator.apply(this.wrap(this.propertyName));
    }

    private String wrap(String name) {
        if (this.propertyNamePrefix == null && this.propertyNameSuffix == null) {
            return name;
        }
        StringBuilder wrapped = new StringBuilder();
        if (this.propertyNamePrefix != null) {
            wrapped.append(this.propertyNamePrefix);
        }
        wrapped.append(name);
        if (this.propertyNameSuffix != null) {
            wrapped.append(this.propertyNameSuffix);
        }
        return wrapped.toString();
    }

    public String getBeanPropertyName() {
        return this.propertyName;
    }

    public FieldInfo getField() {
        return this.field;
    }

    private void setField(FieldInfo field) {
        this.field = field;
    }

    public MethodInfo getReadMethod() {
        return this.readMethod;
    }

    private void setReadMethod(MethodInfo readMethod) {
        if (this.readMethod != null) {
            this.targets.remove(this.readMethod);
        }
        this.readMethod = readMethod;
        if (readMethod != null) {
            this.leaf = readMethod.returnType();
            this.targets.add((AnnotationTarget)readMethod);
        }
    }

    public MethodInfo getWriteMethod() {
        return this.writeMethod;
    }

    private void setWriteMethod(MethodInfo writeMethod) {
        if (this.writeMethod != null) {
            this.targets.remove(this.writeMethod);
        }
        this.writeMethod = writeMethod;
        if (writeMethod != null) {
            this.leaf = (Type)writeMethod.parameters().get(0);
            this.targets.add((AnnotationTarget)writeMethod);
        }
    }

    public Type resolveType() {
        return this.getResolvedType(this.leaf);
    }

    public boolean isIgnored() {
        return this.ignored || this.readOnly && this.readMethod == null || this.writeOnly && this.writeMethod == null;
    }

    private boolean isExposedByDefault() {
        return !this.isIgnored() && !this.exposed;
    }

    private Type getResolvedType(Type fieldType) {
        Type current = TypeUtil.resolveWildcard(fieldType);
        for (Map<String, Type> map : this.resolutionStack) {
            String varName = null;
            switch (current.kind()) {
                case TYPE_VARIABLE: {
                    varName = current.asTypeVariable().identifier();
                    break;
                }
                case UNRESOLVED_TYPE_VARIABLE: {
                    varName = current.asUnresolvedTypeVariable().identifier();
                    break;
                }
            }
            if (varName == null || !map.containsKey(varName)) continue;
            current = map.get(varName);
        }
        return current;
    }

    private static Type[] resolveArguments(ParameterizedType type, UnaryOperator<Type> resolver) {
        return (Type[])type.arguments().stream().map(resolver).toArray(Type[]::new);
    }

    private Type getResolvedType(ParameterizedType type) {
        if (type.arguments().stream().noneMatch(arg -> arg.kind() == Type.Kind.WILDCARD_TYPE)) {
            return ParameterizedType.create((DotName)type.name(), (Type[])TypeResolver.resolveArguments(type, this::resolve), null);
        }
        return this.getResolvedType((Type)type);
    }

    public Type resolve(Type type) {
        Type resolvedType = type == null ? null : (type.kind() == Type.Kind.PARAMETERIZED_TYPE ? this.getResolvedType(type.asParameterizedType()) : this.getResolvedType(type));
        return resolvedType;
    }

    public List<AnnotationTarget> getConstraintTargets() {
        return this.constraintTargets;
    }

    public static TypeResolver forClass(AnnotationScannerContext context, ClassInfo clazz, Type leaf) {
        AugmentedIndexView index = context.getAugmentedIndex();
        Type clazzType = leaf != null ? leaf : Type.create((DotName)clazz.name(), (Type.Kind)Type.Kind.CLASS);
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(index, clazz, clazzType);
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        boolean allOfMatch = false;
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                Map<String, Type> resMap = TypeResolver.buildParamTypeResolutionMap(currentClass, currentType.asParameterizedType());
                stack.push(resMap);
            }
            if (!allOfMatch && (currentType.equals((Object)clazzType) || !TypeUtil.isIncludedAllOf(clazz, currentType))) continue;
            allOfMatch = true;
        }
        return new TypeResolver(TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)clazz), null, null, stack);
    }

    public static Map<String, TypeResolver> getAllFields(AnnotationScannerContext context, Type leaf, ClassInfo leafKlazz, AnnotationTarget reference) {
        AugmentedIndexView index = context.getAugmentedIndex();
        Map<ClassInfo, Type> chain = JandexUtil.inheritanceChain(index, leafKlazz, leaf);
        LinkedHashMap<String, TypeResolver> properties = new LinkedHashMap<String, TypeResolver>();
        ArrayDeque<Map<String, Type>> stack = new ArrayDeque<Map<String, Type>>();
        boolean skipPropertyScan = false;
        for (Map.Entry<ClassInfo, Type> entry : chain.entrySet()) {
            ClassInfo currentClass = entry.getKey();
            Type currentType = entry.getValue();
            if (currentType.kind() == Type.Kind.PARAMETERIZED_TYPE) {
                Map<String, Type> resMap = TypeResolver.buildParamTypeResolutionMap(currentClass, currentType.asParameterizedType());
                stack.push(resMap);
            }
            if (skipPropertyScan || !currentType.equals((Object)leaf) && TypeUtil.isIncludedAllOf(leafKlazz, currentType) || TypeUtil.knownJavaType(currentClass.name())) {
                skipPropertyScan = true;
                continue;
            }
            TypeResolver.fields(context, currentClass).stream().filter(TypeResolver::acceptField).forEach(field -> TypeResolver.scanField(context, properties, field, stack, reference));
            TypeResolver.methods(context, currentClass).stream().filter(TypeResolver::acceptMethod).forEach(method -> TypeResolver.scanMethod(context, properties, method, stack, reference));
            TypeResolver.interfaces(index, currentClass).stream().filter(type -> !TypeUtil.knownJavaType(type.name())).map(index::getClass).filter(Objects::nonNull).flatMap(clazz -> TypeResolver.methods(context, clazz).stream()).forEach(method -> TypeResolver.scanMethod(context, properties, method, stack, reference));
        }
        if (!context.getConfig().privatePropertiesEnable()) {
            properties.values().stream().filter(TypeResolver::isExposedByDefault).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.field)).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.readMethod)).filter(resolver -> TypeResolver.isNonPublicOrAbsent(resolver.writeMethod)).forEach(property -> {
                property.ignored = true;
            });
        }
        return TypeResolver.sorted(properties, chain.keySet());
    }

    private static List<FieldInfo> fields(AnnotationScannerContext context, ClassInfo currentClass) {
        if (context.getConfig().sortedPropertiesEnable()) {
            return currentClass.fields();
        }
        return currentClass.unsortedFields();
    }

    private static List<MethodInfo> methods(AnnotationScannerContext context, ClassInfo currentClass) {
        if (context.getConfig().sortedPropertiesEnable()) {
            return currentClass.methods();
        }
        return currentClass.unsortedMethods();
    }

    private static boolean acceptMethod(MethodInfo method) {
        if (Modifier.isStatic(method.flags())) {
            return false;
        }
        String name = method.name();
        return !name.equals("<init>") && !name.equals("getClass");
    }

    private static boolean acceptField(FieldInfo field) {
        return !Modifier.isStatic(field.flags()) && !field.isSynthetic();
    }

    private static boolean isNonPublicOrAbsent(FieldInfo field) {
        return field == null || !Modifier.isPublic(field.flags());
    }

    private static boolean isNonPublicOrAbsent(MethodInfo method) {
        return method == null || !Modifier.isPublic(method.flags());
    }

    private static Set<Type> interfaces(AugmentedIndexView index, ClassInfo klass) {
        LinkedHashSet<Type> interfaces = new LinkedHashSet<Type>();
        for (Type type : klass.interfaceTypes()) {
            interfaces.add(type);
            if (!index.containsClass(type)) continue;
            interfaces.addAll(TypeResolver.interfaces(index, index.getClass(type)));
        }
        return interfaces;
    }

    private void processVisibility(AnnotationTarget target, AnnotationTarget reference, IgnoreResolver ignoreResolver) {
        if (this.exposed || this.ignored) {
            return;
        }
        if (this.isUnhidden(target)) {
            this.exposed = true;
            return;
        }
        IgnoreResolver.Visibility visibility = ignoreResolver.isIgnore(target, reference);
        switch (visibility) {
            case EXPOSED: {
                this.exposed = true;
                break;
            }
            case IGNORED: {
                if (target.kind() == AnnotationTarget.Kind.METHOD) {
                    if (TypeResolver.isAccessor(target.asMethod())) {
                        this.writeOnly = true;
                    } else {
                        this.readOnly = true;
                    }
                    if (!this.readOnly || !this.writeOnly) break;
                    this.ignored = true;
                    break;
                }
                this.ignored = true;
                break;
            }
        }
    }

    boolean isUnhidden(AnnotationTarget target) {
        Boolean hidden;
        AnnotationInstance schemaAnnotation;
        return target != null && (schemaAnnotation = TypeUtil.getSchemaAnnotation(target)) != null && ((hidden = (Boolean)JandexUtil.value(schemaAnnotation, "hidden")) == null || hidden == false);
    }

    private static void scanField(AnnotationScannerContext context, Map<String, TypeResolver> properties, FieldInfo field, Deque<Map<String, Type>> stack, AnnotationTarget reference) {
        TypeResolver resolver;
        boolean unwrapped;
        String propertyName = field.name();
        Type fieldType = field.type();
        ClassInfo fieldClass = context.getAugmentedIndex().getClass(fieldType);
        if (field.hasAnnotation(JacksonConstants.JSON_UNWRAPPED) && fieldClass != null) {
            unwrapped = true;
            properties.putAll(TypeResolver.unwrapProperties(context, (AnnotationTarget)field, fieldType, fieldClass));
        } else {
            unwrapped = false;
        }
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (resolver.getField() == null && (Modifier.isPublic(field.flags()) || Modifier.isProtected(field.flags()))) {
                resolver.setField(field);
            }
        } else {
            resolver = new TypeResolver(TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)field), propertyName, field, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        if (BeanValidationScanner.hasConstraints((AnnotationTarget)field)) {
            resolver.constraintTargets.add((AnnotationTarget)field);
        }
        if (unwrapped) {
            resolver.ignored = true;
        } else {
            resolver.processVisibility((AnnotationTarget)field, reference, context.getIgnoreResolver());
        }
    }

    private static Map<String, TypeResolver> unwrapProperties(AnnotationScannerContext context, AnnotationTarget member, Type memberType, ClassInfo memberClass) {
        Map<String, TypeResolver> unwrappedProperties = TypeResolver.getAllFields(context, memberType, memberClass, member);
        AnnotationInstance jsonUnwrapped = TypeUtil.getAnnotation(member, JacksonConstants.JSON_UNWRAPPED);
        String unwrapPrefix = (String)JandexUtil.value(jsonUnwrapped, "prefix");
        String unwrapSuffix = (String)JandexUtil.value(jsonUnwrapped, "suffix");
        return unwrappedProperties.entrySet().stream().map(p -> TypeResolver.applyPrefixSuffix(p, unwrapPrefix, unwrapSuffix)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static Map.Entry<String, TypeResolver> applyPrefixSuffix(Map.Entry<String, TypeResolver> property, String prefix, String suffix) {
        TypeResolver unwrappedResolver = property.getValue();
        StringBuilder key = new StringBuilder();
        if (prefix != null) {
            unwrappedResolver.propertyNamePrefix = prefix;
            key.append(prefix);
        }
        key.append(property.getKey());
        if (suffix != null) {
            unwrappedResolver.propertyNameSuffix = suffix;
            key.append(suffix);
        }
        return new AbstractMap.SimpleEntry<String, TypeResolver>(key.toString(), unwrappedResolver);
    }

    private static void scanMethod(AnnotationScannerContext context, Map<String, TypeResolver> properties, MethodInfo method, Deque<Map<String, Type>> stack, AnnotationTarget reference) {
        TypeResolver resolver;
        Type returnType = method.returnType();
        Type propertyType = null;
        if (TypeResolver.isAccessor(method)) {
            propertyType = returnType;
        } else if (TypeResolver.isMutator(method)) {
            propertyType = (Type)method.parameters().get(0);
        }
        if (propertyType != null && (resolver = TypeResolver.updateTypeResolvers(context, properties, stack, method, propertyType)) != null) {
            resolver.processVisibility((AnnotationTarget)method, reference, context.getIgnoreResolver());
        }
    }

    private static TypeResolver updateTypeResolvers(AnnotationScannerContext context, Map<String, TypeResolver> properties, Deque<Map<String, Type>> stack, MethodInfo method, Type propertyType) {
        boolean isWriteMethod;
        TypeResolver resolver;
        String propertyName = TypeResolver.propertyName(method);
        if (propertyName == null) {
            return null;
        }
        if (properties.containsKey(propertyName)) {
            resolver = properties.get(propertyName);
            if (!TypeUtil.equalTypes(resolver.getUnresolvedType(), propertyType)) {
                return resolver;
            }
        } else {
            resolver = new TypeResolver(TypeResolver.getPropertyNameTranslator(context, (AnnotationTarget)method), propertyName, null, new ArrayDeque<Map<String, Type>>(stack));
            properties.put(propertyName, resolver);
        }
        if (isWriteMethod = TypeResolver.isMutator(method)) {
            if (TypeResolver.isHigherPriority(method, resolver.getWriteMethod())) {
                resolver.setWriteMethod(method);
            }
        } else if (TypeResolver.isHigherPriority(method, resolver.getReadMethod())) {
            resolver.setReadMethod(method);
        }
        if (BeanValidationScanner.hasConstraints((AnnotationTarget)method)) {
            resolver.constraintTargets.add((AnnotationTarget)method);
        }
        return resolver;
    }

    static String propertyName(MethodInfo method) {
        String propertyName;
        String methodName = method.name();
        int nameStart = TypeResolver.methodNamePrefix(method).length();
        if (methodName.length() == nameStart) {
            return null;
        }
        if (nameStart > 0) {
            StringBuilder nameBuffer = new StringBuilder(methodName.length());
            nameBuffer.append(methodName);
            nameBuffer.setCharAt(nameStart, Character.toLowerCase(methodName.charAt(nameStart)));
            propertyName = nameBuffer.substring(nameStart);
        } else {
            propertyName = methodName;
        }
        return propertyName;
    }

    private static boolean isAccessor(MethodInfo method) {
        Type returnType = method.returnType();
        if (!method.parameters().isEmpty() || Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        String namePrefix = TypeResolver.methodNamePrefix(method);
        if (METHOD_PREFIX_GET.equals(namePrefix)) {
            return true;
        }
        if (METHOD_PREFIX_IS.equals(namePrefix) && TypeUtil.equalTypes(returnType, BOOLEAN_TYPE)) {
            return true;
        }
        return TypeUtil.hasAnnotation((AnnotationTarget)method, SchemaConstant.DOTNAME_SCHEMA);
    }

    private static boolean isMutator(MethodInfo method) {
        Type returnType = method.returnType();
        if (method.parameters().size() != 1 || !Type.Kind.VOID.equals((Object)returnType.kind())) {
            return false;
        }
        return METHOD_PREFIX_SET.equals(TypeResolver.methodNamePrefix(method)) || TypeUtil.hasAnnotation((AnnotationTarget)method, SchemaConstant.DOTNAME_SCHEMA);
    }

    private static String methodNamePrefix(MethodInfo method) {
        String methodName = method.name();
        if (methodName.startsWith(METHOD_PREFIX_GET)) {
            return METHOD_PREFIX_GET;
        }
        if (methodName.startsWith(METHOD_PREFIX_IS)) {
            return METHOD_PREFIX_IS;
        }
        if (methodName.startsWith(METHOD_PREFIX_SET)) {
            return METHOD_PREFIX_SET;
        }
        return "";
    }

    private static boolean isHigherPriority(MethodInfo newMethod, MethodInfo oldMethod) {
        if (oldMethod == null) {
            return true;
        }
        if (Modifier.isInterface(newMethod.declaringClass().flags())) {
            return targetComparator.compare((AnnotationTarget)newMethod, (AnnotationTarget)oldMethod) < 0;
        }
        return false;
    }

    private static UnaryOperator<String> getPropertyNameTranslator(AnnotationScannerContext context, AnnotationTarget target) {
        Type namingClass;
        ClassInfo clazz = target.kind() == AnnotationTarget.Kind.CLASS ? target.asClass() : TypeUtil.getDeclaringClass(target);
        AnnotationInstance jacksonNaming = clazz.classAnnotation(JacksonConstants.JSON_NAMING);
        UnaryOperator<String> translator = jacksonNaming != null ? ((namingClass = (Type)JandexUtil.value(jacksonNaming, "value")) != null ? PropertyNamingStrategyFactory.getStrategy(namingClass.name().toString(), context.getClassLoader()) : PropertyNamingStrategyFactory.getStrategy("IDENTITY", context.getClassLoader())) : context.getPropertyNameTranslator();
        return translator;
    }

    private static Map<String, TypeResolver> sorted(Map<String, TypeResolver> properties, Set<ClassInfo> chainKeys) {
        ArrayList<ClassInfo> chain = new ArrayList<ClassInfo>(chainKeys);
        Collections.reverse(chain);
        List order = chain.stream().map(TypeResolver::propertyOrder).flatMap(Collection::stream).collect(Collectors.toList());
        List chainClassNames = chain.stream().map(ClassInfo::name).collect(Collectors.toList());
        return properties.entrySet().stream().sorted((e1, e2) -> {
            int pIndex2;
            TypeResolver r1 = (TypeResolver)e1.getValue();
            TypeResolver r2 = (TypeResolver)e2.getValue();
            ClassInfo c1 = r1.getDeclaringClass();
            ClassInfo c2 = r2.getDeclaringClass();
            int pIndex1 = order.indexOf(r1.getPropertyName());
            if (pIndex1 < 0) {
                pIndex1 = order.indexOf(e1.getKey());
            }
            if ((pIndex2 = order.indexOf(r2.getPropertyName())) < 0) {
                pIndex2 = order.indexOf(e2.getKey());
            }
            if (pIndex1 > -1) {
                if (pIndex2 < 0) {
                    return -1;
                }
                return Integer.compare(pIndex1, pIndex2);
            }
            if (pIndex2 > -1) {
                return 1;
            }
            int cIndex1 = chainClassNames.indexOf(c1.name());
            int cIndex2 = chainClassNames.indexOf(c2.name());
            return Integer.compare(cIndex1, cIndex2);
        }).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (e1, e2) -> e1, LinkedHashMap::new));
    }

    private static List<String> propertyOrder(ClassInfo clazz) {
        AnnotationValue orderArray = null;
        AnnotationInstance propertyOrder = JandexUtil.getClassAnnotation(clazz, JsonbConstants.JSONB_PROPERTY_ORDER);
        if (propertyOrder != null) {
            orderArray = propertyOrder.value();
        } else {
            propertyOrder = JandexUtil.getClassAnnotation(clazz, JaxbConstants.XML_TYPE);
            if (propertyOrder != null) {
                orderArray = propertyOrder.value("propOrder");
            } else {
                propertyOrder = clazz.classAnnotation(JacksonConstants.JSON_PROPERTY_ORDER);
                if (propertyOrder != null) {
                    orderArray = propertyOrder.value();
                }
            }
        }
        if (orderArray != null) {
            return Arrays.asList(orderArray.asStringArray());
        }
        return Collections.emptyList();
    }

    private static Map<String, Type> buildParamTypeResolutionMap(ClassInfo klazz, ParameterizedType parameterizedType) {
        List typeVariables = klazz.typeParameters();
        List arguments = parameterizedType.arguments();
        if (arguments.size() != typeVariables.size()) {
            DataObjectLogging.logger.classNotAvailable(typeVariables, arguments);
        }
        LinkedHashMap<String, Type> resolutionMap = new LinkedHashMap<String, Type>();
        for (int i = 0; i < arguments.size(); ++i) {
            TypeVariable typeVar = (TypeVariable)typeVariables.get(i);
            Type arg = (Type)arguments.get(i);
            resolutionMap.put(typeVar.identifier(), arg);
        }
        return resolutionMap;
    }

    public static ParameterizedType resolveParameterizedAncestor(AnnotationScannerContext context, ParameterizedType pType, Type seekType) {
        ParameterizedType cursor = pType;
        boolean seekContinue = true;
        while (context.getAugmentedIndex().containsClass((Type)cursor) && seekContinue) {
            ClassInfo cursorClass = context.getIndex().getClassByName(cursor.name());
            Map<String, Type> resolutionMap = TypeResolver.buildParamTypeResolutionMap(cursorClass, cursor);
            List<Type> interfaces = TypeResolver.getInterfacesOfType(context, cursorClass, seekType);
            for (Type implementedType : interfaces) {
                cursor = TypeResolver.createParameterizedType(implementedType, resolutionMap);
                if (!implementedType.name().equals((Object)seekType.name())) continue;
                seekContinue = false;
                break;
            }
            if (!interfaces.isEmpty()) continue;
            Type superType = cursorClass.superClassType();
            if (TypeUtil.isA(context, superType, seekType)) {
                cursor = TypeResolver.createParameterizedType(superType, resolutionMap);
                continue;
            }
            seekContinue = false;
        }
        return cursor;
    }

    private static List<Type> getInterfacesOfType(AnnotationScannerContext context, ClassInfo clazz, Type seekType) {
        return clazz.interfaceTypes().stream().filter(t -> TypeUtil.isA(context, t, seekType)).collect(Collectors.toList());
    }

    private static ParameterizedType createParameterizedType(Type targetType, Map<String, Type> resolutionMap) {
        if (targetType.kind() != Type.Kind.PARAMETERIZED_TYPE) {
            return ParameterizedType.create((DotName)targetType.name(), (Type[])Type.EMPTY_ARRAY, null);
        }
        Type[] resolvedArgs = TypeResolver.resolveArguments(targetType.asParameterizedType(), t -> TypeResolver.resolveType(t, resolutionMap));
        return ParameterizedType.create((DotName)targetType.name(), (Type[])resolvedArgs, null);
    }

    private static Type resolveType(Type type, Map<String, Type> resolutionMap) {
        switch (type.kind()) {
            case PARAMETERIZED_TYPE: {
                return TypeResolver.createParameterizedType(type, resolutionMap);
            }
            case TYPE_VARIABLE: {
                String id = type.asTypeVariable().identifier();
                return resolutionMap.getOrDefault(id, type);
            }
        }
        return type;
    }
}

