/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.mavenplugin;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.jboss.jandex.CompositeIndex;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.JarIndexer;
import org.jboss.jandex.Result;

@Component(role=MavenDependencyIndexCreator.class, instantiationStrategy="singleton")
public class MavenDependencyIndexCreator {
    private final Cache<String, IndexView> indexCache = CacheBuilder.newBuilder().build();
    private final Set<String> ignoredArtifacts = new HashSet<String>();
    @Requirement
    private Logger logger;

    public MavenDependencyIndexCreator() {
        this.ignoredArtifacts.add("org.graalvm.sdk:graal-sdk");
        this.ignoredArtifacts.add("org.yaml:snakeyaml");
        this.ignoredArtifacts.add("org.wildfly.common:wildfly-common");
        this.ignoredArtifacts.add("com.fasterxml.jackson.core:jackson-core");
        this.ignoredArtifacts.add("com.fasterxml.jackson.core:jackson-databind");
        this.ignoredArtifacts.add("io.smallrye.reactive:smallrye-mutiny-vertx-core");
        this.ignoredArtifacts.add("commons-io:commons-io");
        this.ignoredArtifacts.add("io.smallrye.reactive:mutiny");
        this.ignoredArtifacts.add("org.jboss.narayana.jta:narayana-jta");
        this.ignoredArtifacts.add("org.glassfish.jaxb:jaxb-runtime");
        this.ignoredArtifacts.add("com.github.ben-manes.caffeine:caffeine");
        this.ignoredArtifacts.add("org.hibernate.validator:hibernate-validator");
        this.ignoredArtifacts.add("io.smallrye.config:smallrye-config-core");
        this.ignoredArtifacts.add("com.thoughtworks.xstream:xstream");
        this.ignoredArtifacts.add("com.github.javaparser:javaparser-core");
        this.ignoredArtifacts.add("org.jboss:jandex");
        this.ignoredArtifacts.add("org.jboss.resteasy:resteasy-core");
        this.ignoredArtifacts.add("antlr");
        this.ignoredArtifacts.add("io.netty");
        this.ignoredArtifacts.add("org.drools");
        this.ignoredArtifacts.add("net.bytebuddy");
        this.ignoredArtifacts.add("org.hibernate");
        this.ignoredArtifacts.add("org.kie");
        this.ignoredArtifacts.add("org.postgresql");
        this.ignoredArtifacts.add("org.apache.httpcomponents");
    }

    public IndexView createIndex(MavenProject mavenProject, boolean scanDependenciesDisable, List<String> includeDependenciesScopes, List<String> includeDependenciesTypes) throws Exception {
        ArrayList<Map.Entry<Artifact, Duration>> indexDurations = new ArrayList<Map.Entry<Artifact, Duration>>();
        ArrayList<Artifact> artifacts = new ArrayList<Artifact>();
        artifacts.add(mavenProject.getArtifact());
        if (!scanDependenciesDisable) {
            artifacts.addAll(mavenProject.getArtifacts());
        }
        ArrayList<Object> indexes = new ArrayList<Object>();
        for (Artifact artifact : artifacts) {
            if (this.isIgnored(artifact, includeDependenciesScopes, includeDependenciesTypes)) continue;
            try {
                if (artifact.getFile().isDirectory()) {
                    indexes.add(this.indexModuleClasses(artifact));
                    continue;
                }
                if (!artifact.getFile().getName().endsWith(".jar")) continue;
                IndexView artifactIndex = this.timeAndCache(indexDurations, artifact, () -> {
                    Result result = JarIndexer.createJarIndex((File)artifact.getFile(), (Indexer)new Indexer(), (boolean)false, (boolean)false, (boolean)false);
                    return result.getIndex();
                });
                indexes.add(artifactIndex);
            }
            catch (IOException | ExecutionException e) {
                this.logger.error("Can't compute index of " + artifact.getFile().getAbsolutePath() + ", skipping", (Throwable)e);
            }
        }
        this.printIndexDurations(indexDurations);
        return CompositeIndex.create(indexes);
    }

    private void printIndexDurations(List<Map.Entry<Artifact, Duration>> indexDurations) {
        if (this.logger.isDebugEnabled()) {
            indexDurations.sort(Map.Entry.comparingByValue());
            indexDurations.forEach(e -> {
                if (((Duration)e.getValue()).toMillis() > 25L) {
                    this.logger.debug(this.buildGAVCTString((Artifact)e.getKey()) + " " + e.getValue());
                }
            });
        }
    }

    private boolean isIgnored(Artifact artifact, List<String> includeDependenciesScopes, List<String> includeDependenciesTypes) {
        if (artifact.getScope() == null && artifact.getFile() != null) {
            return false;
        }
        return !includeDependenciesScopes.contains(artifact.getScope()) || !includeDependenciesTypes.contains(artifact.getType()) || this.ignoredArtifacts.contains(artifact.getGroupId()) || this.ignoredArtifacts.contains(artifact.getGroupId() + ":" + artifact.getArtifactId());
    }

    private IndexView timeAndCache(List<Map.Entry<Artifact, Duration>> indexDurations, Artifact artifact, Callable<IndexView> callable) throws Exception {
        LocalDateTime start = LocalDateTime.now();
        IndexView result = (IndexView)this.indexCache.get((Object)this.buildGAVCTString(artifact), callable);
        LocalDateTime end = LocalDateTime.now();
        Duration duration = Duration.between(start, end);
        indexDurations.add(new AbstractMap.SimpleEntry<Artifact, Duration>(artifact, duration));
        return result;
    }

    private Index indexModuleClasses(Artifact artifact) throws IOException {
        Indexer indexer = new Indexer();
        if (artifact.getFile().exists()) {
            try (Stream<Path> stream = Files.walk(artifact.getFile().toPath(), new FileVisitOption[0]);){
                List classFiles = stream.filter(path -> path.toString().endsWith(".class")).collect(Collectors.toList());
                for (Path path2 : classFiles) {
                    indexer.index(Files.newInputStream(path2, new OpenOption[0]));
                }
            }
        }
        return indexer.complete();
    }

    private String buildGAVCTString(Artifact artifact) {
        return artifact.getGroupId() + ":" + artifact.getArtifactId() + ":" + artifact.getVersion() + ":" + artifact.getClassifier() + ":" + artifact.getType();
    }
}

