/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.restclient;

import io.smallrye.restclient.PartialResponse;
import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.Set;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.client.ClientRequestContext;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.client.ClientResponseFilter;
import org.eclipse.microprofile.rest.client.ext.ResponseExceptionMapper;

public class ExceptionMapping
implements ClientResponseFilter {
    private Set<Object> instances;

    public ExceptionMapping(Set<Object> instances) {
        this.instances = instances;
    }

    public void filter(ClientRequestContext requestContext, ClientResponseContext responseContext) throws IOException {
        PartialResponse response = new PartialResponse(responseContext);
        HashMap<ResponseExceptionMapper, Integer> mappers = new HashMap<ResponseExceptionMapper, Integer>();
        for (Object o : this.instances) {
            Object candiate;
            if (!(o instanceof ResponseExceptionMapper) || !(candiate = (ResponseExceptionMapper)o).handles(response.getStatus(), response.getHeaders())) continue;
            mappers.put((ResponseExceptionMapper)candiate, candiate.getPriority());
        }
        if (mappers.size() > 0) {
            HashMap errors = new HashMap();
            mappers.forEach((m, i) -> {
                Optional<Throwable> t = Optional.ofNullable(m.toThrowable(response));
                errors.put(t, i);
            });
            Optional prioritised = Optional.empty();
            for (Optional throwable : errors.keySet()) {
                if (!throwable.isPresent()) continue;
                if (!prioritised.isPresent()) {
                    prioritised = throwable;
                    continue;
                }
                if ((Integer)errors.get(throwable) >= (Integer)errors.get(prioritised)) continue;
                prioritised = throwable;
            }
            response.bufferEntity();
            if (prioritised.isPresent()) {
                Throwable throwable = (Throwable)prioritised.get();
                WebApplicationException exception = throwable instanceof WebApplicationException ? (WebApplicationException)throwable : new WebApplicationException(throwable);
                throw exception;
            }
        }
    }
}

