/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.restclient;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.Any;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;
import javax.enterprise.util.AnnotationLiteral;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.rest.client.RestClientBuilder;
import org.eclipse.microprofile.rest.client.inject.RestClient;

public class RestClientDelegateBean
implements Bean<Object>,
PassivationCapable {
    public static final String REST_URL_FORMAT = "%s/mp-rest/url";
    public static final String REST_URI_FORMAT = "%s/mp-rest/uri";
    public static final String REST_SCOPE_FORMAT = "%s/mp-rest/scope";
    public static final String REST_CONNECT_TIMEOUT_FORMAT = "%s/mp-rest/connectTimeout";
    public static final String REST_READ_TIMEOUT_FORMAT = "%s/mp-rest/readTimeout";
    public static final String REST_PROVIDERS = "%s/mp-rest/providers";
    private static final String PROPERTY_PREFIX = "%s/property/";
    private final Class<?> proxyType;
    private final Class<? extends Annotation> scope;
    private final BeanManager beanManager;
    private final Config config;
    private final Optional<String> baseUri;

    RestClientDelegateBean(Class<?> proxyType, BeanManager beanManager, Optional<String> baseUri) {
        this.proxyType = proxyType;
        this.beanManager = beanManager;
        this.config = ConfigProvider.getConfig();
        this.scope = this.resolveScope();
        this.baseUri = baseUri;
    }

    public String getId() {
        return this.proxyType.getName();
    }

    public Class<?> getBeanClass() {
        return this.proxyType;
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return Collections.emptySet();
    }

    public boolean isNullable() {
        return false;
    }

    public Object create(CreationalContext<Object> creationalContext) {
        RestClientBuilder builder = RestClientBuilder.newBuilder();
        this.configureUri(builder);
        this.configureTimeouts(builder);
        this.configureProviders(builder);
        this.getConfigProperties().forEach((arg_0, arg_1) -> ((RestClientBuilder)builder).property(arg_0, arg_1));
        return builder.build(this.proxyType);
    }

    private void configureProviders(RestClientBuilder builder) {
        Optional<String> maybeProviders = this.getOptionalProperty(REST_PROVIDERS, String.class);
        maybeProviders.ifPresent(providers -> this.registerProviders(builder, (String)providers));
    }

    private void registerProviders(RestClientBuilder builder, String providersAsString) {
        Stream.of(providersAsString.split(",")).map(String::trim).map(this::providerClassForName).forEach(arg_0 -> ((RestClientBuilder)builder).register(arg_0));
    }

    private Class<?> providerClassForName(String name) {
        try {
            return Class.forName(name, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not find provider class: " + name);
        }
    }

    private void configureTimeouts(RestClientBuilder builder) {
        Optional<Long> connectTimeout = this.getOptionalProperty(REST_CONNECT_TIMEOUT_FORMAT, Long.class);
        connectTimeout.ifPresent(timeout -> builder.connectTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
        Optional<Long> readTimeout = this.getOptionalProperty(REST_READ_TIMEOUT_FORMAT, Long.class);
        readTimeout.ifPresent(timeout -> builder.readTimeout(timeout.longValue(), TimeUnit.MILLISECONDS));
    }

    private void configureUri(RestClientBuilder builder) {
        Optional<String> baseUriFromConfig = this.getOptionalProperty(REST_URI_FORMAT, String.class);
        Optional<String> baseUrlFromConfig = this.getOptionalProperty(REST_URL_FORMAT, String.class);
        if (baseUriFromConfig.isPresent()) {
            builder.baseUri(RestClientDelegateBean.uriFromString(baseUriFromConfig.get()));
        } else if (baseUrlFromConfig.isPresent()) {
            builder.baseUrl(this.urlFromString(baseUrlFromConfig, baseUrlFromConfig.get()));
        } else {
            this.baseUri.ifPresent(uri -> builder.baseUri(RestClientDelegateBean.uriFromString(uri)));
        }
    }

    private <T> Optional<T> getOptionalProperty(String propertyFormat, Class<T> type) {
        return this.config.getOptionalValue(String.format(propertyFormat, this.proxyType.getName()), type);
    }

    private URL urlFromString(Optional<String> baseUrlFromConfig, String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException("The value of URL was invalid " + baseUrlFromConfig);
        }
    }

    private static URI uriFromString(String uriString) {
        try {
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException("The value of URI was invalid " + uriString);
        }
    }

    public void destroy(Object instance, CreationalContext<Object> creationalContext) {
    }

    public Set<Type> getTypes() {
        return Collections.singleton(this.proxyType);
    }

    public Set<Annotation> getQualifiers() {
        HashSet<Annotation> qualifiers = new HashSet<Annotation>();
        qualifiers.add((Annotation)new AnnotationLiteral<Default>(){});
        qualifiers.add((Annotation)new AnnotationLiteral<Any>(){});
        qualifiers.add((Annotation)RestClient.LITERAL);
        return qualifiers;
    }

    public Class<? extends Annotation> getScope() {
        return this.scope;
    }

    public String getName() {
        return this.proxyType.getName();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return Collections.emptySet();
    }

    public boolean isAlternative() {
        return false;
    }

    private Map<String, Integer> getConfigProperties() {
        String property = String.format(PROPERTY_PREFIX, this.proxyType.getName());
        HashMap<String, Integer> configProperties = new HashMap<String, Integer>();
        for (String propertyName : this.config.getPropertyNames()) {
            if (!propertyName.startsWith(property)) continue;
            Integer value = (Integer)this.config.getValue(propertyName, Integer.class);
            String strippedProperty = propertyName.replace(property, "");
            configProperties.put(strippedProperty, value);
        }
        return configProperties;
    }

    private Class<? extends Annotation> resolveScope() {
        Annotation[] annotations;
        String property = String.format(REST_SCOPE_FORMAT, this.proxyType.getName());
        String configuredScope = this.config.getOptionalValue(property, String.class).orElse(null);
        if (configuredScope != null) {
            try {
                return Class.forName(configuredScope);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Invalid scope: " + configuredScope, e);
            }
        }
        ArrayList<Annotation> possibleScopes = new ArrayList<Annotation>();
        for (Annotation annotation : annotations = this.proxyType.getDeclaredAnnotations()) {
            if (!this.beanManager.isScope(annotation.annotationType())) continue;
            possibleScopes.add(annotation);
        }
        if (possibleScopes.isEmpty()) {
            return Dependent.class;
        }
        if (possibleScopes.size() == 1) {
            return ((Annotation)possibleScopes.get(0)).annotationType();
        }
        throw new IllegalArgumentException("Ambiguous scope definition on " + this.proxyType + ": " + possibleScopes);
    }
}

