/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.restclient;

import io.smallrye.restclient.RestClientDelegateBean;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterBeanDiscovery;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessAnnotatedType;
import javax.enterprise.inject.spi.WithAnnotations;
import org.eclipse.microprofile.rest.client.inject.RegisterRestClient;

public class RestClientExtension
implements Extension {
    private static Set<RestClientData> proxyTypes = new LinkedHashSet<RestClientData>();
    private static Set<Throwable> errors = new LinkedHashSet<Throwable>();

    public void registerRestClient(@Observes @WithAnnotations(value={RegisterRestClient.class}) ProcessAnnotatedType<?> type) {
        Class javaClass = type.getAnnotatedType().getJavaClass();
        if (javaClass.isInterface()) {
            Optional<String> maybeUri = this.extractBaseUri(type);
            proxyTypes.add(new RestClientData(javaClass, maybeUri));
            type.veto();
        } else {
            errors.add(new IllegalArgumentException("Rest client needs to be an interface " + javaClass));
        }
    }

    private Optional<String> extractBaseUri(ProcessAnnotatedType<?> type) {
        RegisterRestClient annotation = (RegisterRestClient)type.getAnnotatedType().getAnnotation(RegisterRestClient.class);
        String baseUri = annotation.baseUri();
        return Optional.ofNullable("".equals(baseUri) ? null : baseUri);
    }

    public void createProxy(@Observes AfterBeanDiscovery afterBeanDiscovery, BeanManager beanManager) {
        for (RestClientData clientData : proxyTypes) {
            afterBeanDiscovery.addBean((Bean)new RestClientDelegateBean(clientData.javaClass, beanManager, clientData.baseUri));
        }
    }

    public void reportErrors(@Observes AfterDeploymentValidation afterDeploymentValidation) {
        for (Throwable error : errors) {
            afterDeploymentValidation.addDeploymentProblem(error);
        }
    }

    private static class RestClientData {
        private final Class<?> javaClass;
        private final Optional<String> baseUri;

        public RestClientData(Class<?> javaClass, Optional<String> baseUri) {
            this.javaClass = javaClass;
            this.baseUri = baseUri;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RestClientData that = (RestClientData)o;
            return this.javaClass.equals(that.javaClass);
        }

        public int hashCode() {
            return Objects.hash(this.javaClass);
        }
    }
}

