/**
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not use this classpath except in compliance with
 * the License. You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software distributed under the License is distributed on
 * an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the License for the
 * specific language governing permissions and limitations under the License.
 *
 * Copyright 2016-2016 SpectoLabs Ltd.
 */
package io.specto.hoverfly.junit.core;

import com.fasterxml.jackson.annotation.JsonValue;

/**
 * Enums denoting the possible modes for {@link Hoverfly}
 */
public enum HoverflyMode {
    SIMULATE("simulate"),
    CAPTURE("capture"),
    SPY("spy"),
    SYNTHESIZE("synthesize"),
    MODIFY("modify"),
    DIFF("diff");


    String value;

    HoverflyMode(String value) {
        this.value = value;
    }

    @JsonValue
    public String getValue() {
        return value;
    }

    public boolean allowSimulationImport() {
        return this == SIMULATE || this == SPY || this == DIFF;
    }
}
